/* global categoryTree, $root, mqrkaTree, form, Popup_product_fillCatSelect, loadPlugins, categoryAttr, dropdown, Dropdown */
( function ($, window, document, undefined) {

    var popup_edit_product_seo = popup_edit_product_seo || {};
    let v = popup_edit_product_seo;
    let helpers, ui;

    popup_edit_product_seo = {
        '__var': {
            formReady: false,
            $modal: $('#' + $('.modal').attr('id')),
        },
        init: function () {
            v = this.__var;
            helpers = this.helpers;
            ui = this.ui;

       
            this.waitForSeoForm();
            this.setUpListeners();
        },
        'setUpListeners': function () {
            const NS = 'seo';

            v.$modal.off(`.${NS}`)
                    .on(`input.${NS}`, '#seo_title, #seo_description',
                            ui.updateMeterAndScore)
                    .on(`input.${NS} change.${NS}`,
                            '#focus_keyword, #seo_slug, #canonical_url, #noindex, .seo-image-alt, .seo-image-title',
                            ui.updateScore);
        },

        /* WAIT FOR FORM (MutationObserver)
         * =======================================================*/
        'waitForSeoForm': function () {
            if (v.formReady)
                return;

            const check = () => {
                if ($('#seo_title, #seo_description').length) {
                    helpers.initMeters();
                    ui.updateScore();

                    v.formReady = true;
                }
                else {
                    setTimeout(check, 200);
                }
            };
            check();
        },

        /*  UI  (NO this)
         * =======================================================*/
        'ui': {
            'updateScore': function () {
                var val = helpers.getScore();
                var $tips = $('#seoScoreTips');

                var cfg =
                        val < 40 ? [ '#dc3545', 'Слабо',
                            'Има сериозни SEO пропуски.' ]
                        : val < 70 ? [ '#ffc107', 'Добре',
                            'Има какво да се подобри.' ]
                        : [ '#28a745', 'Отлично', 'SEO състоянието е добро.' ];

                $('#seoScoreCircle')
                        .css('background', cfg[0])
                        .toggleClass('pulse', val === 100);

                $('#seoScoreValue').text(val + '%');
                $('#seoScoreLabel').text(cfg[1]);

                if ($tips.length) {
                    $tips.text(cfg[2]);
                }

                ui.updateRecommendations();
            },

            'updateMeterAndScore': function () {
                var f = helpers.fields.find(f => f.id === this.id);

                if (f) {
                    ui.updateMeter(
                            $('#' + f.id),
                            f.min, f.max,
                            $('#' + f.meter),
                            $('#' + f.feedback)
                            );
                }

                ui.updateScore();
            },

            'updateMeter': function ($input, min, max, $bar, $text) {
                var len = $.trim($input.val()).length;
                var percent = Math.min(len / max * 100, 100);

                var state = len < min * 0.6
                        ? [ '#dc3545', 'Слабо' ] : len < min
                        ? [ '#ffc107', 'Почти добре' ] : len <= max
                        ? [ '#28a745', 'Оптимално' ] : [ '#fd7e14',
                    'Прекалено дълго' ];

                $bar.css({width: percent + '%', background: state[0]});
                $text.text(state[1] + ' (' + len + ')');
            },

            'updateRecommendations': function () {
                var $rec = $('#seoChecklist');
                if (! $rec.length)
                    return;

                $rec.empty();

                var title = helpers.getVal('seo_title');
                var desc = helpers.getVal('seo_description');
                var keywords = helpers.getVal('focus_keyword');
                var slug = helpers.getVal('seo_slug');
                var noindex = helpers.getChecked('noindex');
                var add = cfg => items.push([ cfg[2], cfg[1] ]);
                var icon = {good: '✅', warn: '⚠️', bad: '❌'};
                var items = [ ];

                /* TITLE */
                add(title.length < 30
                        ? [ null, 'bad', 'Добави по-дълго SEO Title.' ]
                        : title.length < 50
                        ? [ null, 'warn', 'SEO Title може да е по-дълъг.' ]
                        : [ null, 'good', 'SEO Title изглежда добре.' ]);

                // DESCRIPTION */
                add(desc.length < 100
                        ? [ null, 'bad', 'SEO Description е твърде кратко.' ]
                        : desc.length < 140
                        ? [ null, 'warn', 'Добави още детайл.' ]
                        : [ null, 'good', 'SEO Description е оптимално.' ]);

                // KEYWORDS */
                add(keywords
                        ? [ null, 'good', 'Ключовите думи са попълнени.' ]
                        : [ null, 'bad', 'Добави ключови думи.' ]);

                // SLUG */
                add(/^[a-z0-9-]+$/.test(slug)
                        ? [ null, 'good', 'Slug е валиден.' ]
                        : [ null, 'bad', 'Slug трябва да е на латиница.' ]);

                // NOINDEX */
                add(
                        noindex
                        ? [ null, 'warn',
                            '⚠️ noindex е активен — страницата няма да се индексира.'
                        ]
                        : [ null, 'good', 'Страницата ще се индексира.' ]
                        );

                // image-by-image checklist */
                $('.image-seo-block').each(function (i) {
                    var $b = $(this);
                    var alt = $.trim($b.find('.seo-image-alt').val() || '');
                    var ttl = $.trim($b.find('.seo-image-title').val() || '');
                    var label = $.trim($b.find('strong').text
                            ()) || ( 'Снимка ' + ( i + 1 ) );

                    add(! alt && ! ttl
                            ? [ null, 'bad', label + ': липсват ALT и Title.'
                            ] : ! alt
                            ? [ null, 'warn', label + ': липсва ALT текст.'
                            ] : ! ttl
                            ? [ null, 'warn', label + ': липсва Title.' ] : [
                        null, 'good', label + ': оптимизирана.' ]
                            );
                });

                $.each(items, function (_, it) {
                    $rec.append(`
                            <div class="seo-check-item ${it[1]}"><i>${icon[it[1]]}</i> ${it[0]}</div>`);
                });
            }
        },

        /* HELPERS (NO this)
         * =======================================================*/
        'helpers': {
            'fields': [
                {id: 'seo_title', min: 50, max: 60, meter: 'seo_title_meter', feedback: 'seo_title_feedback'},
                {id: 'seo_description', min: 140, max: 160, meter: 'seo_description_meter', feedback: 'seo_description_feedback'}
            ],

            'getVal': function (id) {
                var $el = $('#' + id);
                return $el.length ? $.trim($el.val()) : '';
            },

            'getChecked': function (id) {
                var $el = $('#' + id);
                return $el.length ? $el.is(':checked') : false;
            },

            'uniqueArray': function (arr) {
                return [ ...new Set(arr) ];
            },

            'getScore': function () {
                var score = 0, imgOk = 0, imgRatio = 0;
                var title = helpers.getVal('seo_title');
                var desc = helpers.getVal('seo_description');
                var keywords = helpers.getVal('focus_keyword');
                var slug = helpers.getVal('seo_slug');
                var canonical = helpers.getVal('canonical_url');
                /* images */
                var $blocks = $('.image-seo-block');

                $blocks.each(function () {
                    var $b = $(this);
                    var alt = $.trim($b.find('.seo-image-alt').val() || '');
                    var ttl = $.trim($b.find('.seo-image-title').val() || '');
                    var $dot = $b.find('.status-dot');
                    var state = alt && ttl ? 'good' : alt || ttl ? 'warn'
                            : 'bad';

                    $dot.length && $dot.attr('class', 'status-dot ' + state);
                    state === 'good' && imgOk ++;
                });

                imgRatio = $blocks.length ? imgOk / $blocks.length : 1;

                /* title */
                score += title.length >= 50 && title.length <= 60 ? 30 :
                        title.length >= 35 && title.length <= 75 ? 20 :
                        title.length >= 20 ? 10 : 0;

                /* description */
                score += desc.length >= 140 && desc.length <= 160 ? 30 :
                        desc.length >= 100 && desc.length <= 200 ? 20 :
                        desc.length > 50 ? 10 : 0;

                /* keywords */
                var kws = helpers.uniqueArray(
                        keywords.split(',')
                        .map(k => k.trim().toLowerCase().normalize('NFKD'))
                        .filter(k => k.length > 2));

                score += kws.length >= 4 ? 20 :
                        kws.length >= 2 ? 15 :
                        kws.length >= 1 ? 8 : 0;

                /* images score */
                score += imgRatio === 1 ? 15 :
                        imgRatio >= 0.5 ? 10 :
                        imgRatio > 0 ? 5 : 0;

                /* misc */
                score += slug.length > 5 && /^[a-z0-9-]+$/.test(slug) ? 3 : 0;
                score += canonical.indexOf('http') === 0 ? 2 : 0;

                score = Math.min(100, Math.round(score));

                if (
                        title.length >= 50 &&
                        desc.length >= 140 &&
                        kws.length >= 3 &&
                        imgRatio >= 0.8 &&
                        score >= 90
                        ) {
                    score = 100;
                }

                return score;
            },

            'initMeters': function () {
                helpers.fields.forEach(function (f) {
                    var $input = $('#' + f.id);
                    if (! $input.length)
                        return;

                    ui.updateMeter($input, f.min, f.max, $('#' + f.meter), $(
                            '#' + f.feedback));
                });
            }
        }
    };

    popup_edit_product_seo.init();

} )(jQuery, window, document);
