/* global categoryTree, $root, mqrkaTree, form, Popup_product_fillCatSelect, loadPlugins, categoryAttr, dropdown, Dropdown */

( function ($, window, document, undefined) {

    var popup_product_edit = popup_product_edit || {};
    let v = popup_product_edit;
    let self = popup_product_edit;

    popup_product_edit = {
        '__initializedEvents': false,
        '__var': {
            $modal: $('#' + $('.modal').attr('id')),
            table: '#tbl_products'
        },
        'init': function ( ) {
            if (this.__initializedEvents) {
                return;
            }
            this.__initializedEvents = true;

            v = this.__var;
            self = this;

            this.plugins( );
            this.setUpListeners( );
        },
        'plugins': function ( ) {
            Lp = loadPlugins;
            Dn = dropdown;

            Lp.zoomImg({'isModal': true});
            Lp.inputMask();
            Lp.ul_move({'el': v.$modal.find('#tabProperty .ul-sortable'), 'handle': '.fa-arrows'});
            Lp.selectpicker( );

        },
        'setUpListeners': function ( ) {
            v.$modal.off();

            // POPUP
            v.$modal
                    .on('click', '#open_popupCategory, #open_popupCategoryAttr', this.modal.open_popup_category);
            //v.$modal.on('click', '.modalMqrkaOpen', this.modal.open_popup_mqrka);

            // EVENTS 
            v.$modal
                    // trim при въвеждане в textbox 
                    .on('change paste', '.txtProdAttr', (e) => {
                        $(e.target).val($.trim($(e.target).val( )));
                    })
                    .on('blur', '#priceDostavna, #kkc ', function ( ) {
                        var numDec = this.value;
                        if (numDec != '') {
                            this.value = Lp.toFixed(this.value);
                        }
                    })
                    // при промяна на категория
                    .on('change', 'select#category_id', this.events.change_category)
                    .on('change', 'select.subcatGroup', this.events.change_subCat)
                    // при промяна на кратко описание
                    .on('change', '.is_shortDesc', this.events.isShortDesc);

            // BTN
            v.$modal
                    .on('click', '.dropdownBtn', function ( ) {
                        Dn.init();
                    })
                    .on('click', '#addAttrToDeskcription', this.btn.add_attrToDeskcription)
                    .on('click', '.imgPreview, .aditionalImages', this.btn.ckfinder)
                    .on('click', '.removeImage', this.btn.removeImage)
                    .on('click', '.chk_label', this.btn.labels)
                    .on('click', '#clone', this.btn.clone)
                    .on('click', '#refresh-block-category', function (e) {
                        let refreshRoute = $(this).data('route');
                        v.$modal.find("#block-category").load(refreshRoute + " #block-category>*", function () {
                            $(".modal .selectpicker").selectpicker('refresh');
                        });
                    })

                    // header
                    .on('click', '#save', this.btn.save);
        },
        'modal': {
            'open_popup_category': function ( ) {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            }
        },

        'events': {
            //кратко или дълго описание
            'isShortDesc': function ( ) {
                const isLong = $(this).data('long');

                $('.description').toggleClass('hide');

                v.$modal.find('#tabOsnovniDani #addAttrToDeskcription').prop('disabled', ! isLong);
            },

            'change_category': function (e) {
                var __this = $(this);
                var route = __this.data('route');
                var category = __this.find('option[value]:selected');
                var subCat1 = v.$modal.find('select#subCat1');
                var productId = v.$modal.find('.modal-title #productId');
                var tabProperty = v.$modal.find('#tabProperty');
                var selectPickerEl = $('.selectpicker');

                // Скрий всички подкатегории СЛЕД тази
                v.$modal.find('.subcatGroup').val('').closest('section').hide();

                if (__this.val() == '') {
                    return false;
                }

                productId = productId.text( ).match(/\d+/) ? productId.text( ).match(/\d+/)[0] : '';

                // попълване на select box категории
                $.ajax({
                    url: route,
                    type: 'GET',
                    data: {'productId': productId, 'category_id': category.val( )},
                    dataType: 'json',
                    success: function (response) {

                        if (typeof response.selectBoxHtml !== 'undefined' && response.selectBoxHtml !== '') {
                            subCat1.closest('section').show();
                            subCat1.html(response.selectBoxHtml);
                            subCat1.selectpicker('refresh');
                            // нулира таб х-ки
                            tabProperty.html(response.categoryProperties);
                        }
                        else {
                            subCat1.html('').addClass('pointer-events-none');
                            selectPickerEl.selectpicker('refresh');
                            tabProperty.html('');
                        }

                        if (category.val( ) != '') {
                            selectPickerEl.selectpicker('refresh');
                            subCat1.parent( ).removeClass('pointer-events-none');
                        }
                        else {
                            subCat1.html('').addClass('pointer-events-none');
                            selectPickerEl.selectpicker('refresh');
                        }

                        htmx.process(tabProperty[0]);
                    }
                });
                e.stopImmediatePropagation( );
            },

            'change_subCat': function (e) {
                e.stopImmediatePropagation( );

                const $select = $(this); // текущият select (напр. #subCat1, #subCat2 )
                let route = $select.data('route');
                let selectedOption = $select.find('option[value]:selected');
                let currentLevel = parseInt($select.attr('id').replace('subCat', ''));
                let nextLevel = currentLevel + 1;
                let $nextSelect = v.$modal.find(`#subCat${nextLevel}`);
                let $tabProperty = v.$modal.find('#tabProperty');
                let productIdText = v.$modal.find('.modal-title #productId').text();
                let productId = productIdText.match(/\d+/) ? productIdText.match(/\d+/)[0] : '';

                // === 2. Скриване и ресетване на следващите select-и ===
                for (let i = nextLevel; i <= 4; i ++) {
                    v.$modal.find(`#subCat${i}`)
                            .closest('section')
                            .hide().end().val('')
                            .selectpicker('refresh');
                }

                // === 3. Премахване на .active от всички select-и в групата ===
                v.$modal.find('select.subcatGroup').removeClass('active');

                // === 4. Ако няма избрана стойност или сме на последно ниво ===
                if (! $select.val() || currentLevel >= 4) {
                    let $prevSelect = v.$modal.find(`#subCat${currentLevel - 1}`);

                    if ($prevSelect.length) {
                        $prevSelect.addClass('active').trigger('change');
                    }
                    return false;
                }

                // === 5. Обновяване на селекцията и маркиране като активен ===
                $select.find('option').removeAttr('selected');
                $select.find(`option[value="${selectedOption.val()}"]`).attr('selected', 'selected');
                $select.addClass('active');

                $.ajax({
                    url: route,
                    type: 'GET',
                    data: {
                        'productId': productId,
                        'subCatId': selectedOption.val( ),
                        'tip': v.$modal.data('tip')
                    },
                    dataType: 'json',
                    success: function (res) {
                        // обновяване на характерисиките в таба х-ки само ако променим подкатегория ниво 1
                        $tabProperty.html(res.categoryProperties);
                        $tabProperty.find('#properyName').text(selectedOption.text( ));
                        Lp.count_validate_chk_productAttr(v.$modal);
                        htmx.process($tabProperty[0]);

                        // ако има вложени подкатегории
                        if (res.selectBoxHtml) {
                            if ($nextSelect.length) {
                                $nextSelect.closest('section').show();
                            }

                            $nextSelect.html(res.selectBoxHtml).selectpicker('refresh');
                        }
                    }
                });
            }
        },

        'btn': {

            // добавяне на х-ки в описанието на продукта
            'add_attrToDeskcription': function (e) {
                e.stopImmediatePropagation( );
                const tabProperty = v.$modal.find('#tabProperty');
                let currentDescription = CKEDITOR.instances['ck_area'].getData();
                let updatedContent = '';

                if (! confirm('Да се добавят ли характеристиките към дългото описание?')) {
                    return false;
                }

                tabProperty.find('li').each(function () {
                    const categoryAttrName = $(this).find('.categoryAttrName').text().trim();
                    const categoryAttrValue = $(this).find('.productAttrText').text().trim();
                    if (categoryAttrValue) {
                        updatedContent += `<strong>${categoryAttrName}</strong>:&nbsp; ${categoryAttrValue}<br>`;
                    }
                });

                currentDescription = updatedContent + ( currentDescription.trim() ? '<br>' + currentDescription : '' );

                if (updatedContent) {
                    CKEDITOR.instances['ck_area'].setData(currentDescription);
                }
                else {
                    alert('Не съществува стойсност на характеристиките.');
                }
            },

            // картинка етикет за продукт
            'labels': function ( ) {
                $('.chk_label').not(this).prop('checked', false);
            },

            'clone': function ( ) {
                let route = $(this).data('route');
                let productName = v.$modal.find('input#produktName').val( );
                let newProductName = prompt(LANGpop__editProduct.promt.enterName, productName);

                if (! newProductName.trim()) {
                    alert(LANGpop__editProduct.alert.emptyProdName);
                    return false;
                }

                if (! confirm(LANGpop__editProduct.confirm.clone_product)) {
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: {'newProductName': newProductName.trim()},
                    dataType: 'json',
                    success: function (response) {
                        if (response.dub === true) {
                            alert(response.data);
                            return false;
                        }
                        // е view product се презарежда стр.
                        if (response.spProduct === true) {
                            history.go(0);
                            return false;
                        }

                        if (response.lastId === true) {
                            // Искате ли да добавите новосъздадения продукт към офертата
                            if (confirm(LANGpop__editProduct.confirm.add_product) == true) {
                                $(v.table).find('tbody').append(response.data);
                                $root.plugins( );
                            }
                        }

                        $('.modal').modal('toggle');
                    }
                });
            },

            'removeImage': function (e) {
                e.stopImmediatePropagation( );
                var imgPreview = $(this).closest('.imgPreview');
                var section = $(this).closest('section');
                var brandId = section.find('#brandId').val( );
                const modelId = section.find('#brand_model_id:hidden').val();
                var isBrand = $(this).data('isBrand');
                var role = imgPreview.data('role') || '';

                if (imgPreview.find('img').attr('src') != '' && confirm(LANGpop__editProduct.delete_image)) {

                    imgPreview.find('img').attr('src', '');
                    imgPreview.find('input.avatar').attr('value', '');
                    imgPreview.find('.camera').addClass('fa-camera w-100 m-auto');

                    // ако изтриваме снимка различна от тази на марката
                    if (typeof isBrand === 'undefined') {
                        return false;
                    }

                    $.ajax({
                        url: $(this).data('route'),
                        type: 'POST',
                        data: {'role': role, 'brandId': brandId, 'modelId': modelId},
                        dataType: 'json',
                        success: function (response) {

                        }
                    });
                }
            },
            'save': function (e) {
                e.stopImmediatePropagation( );
                let msg = '';
                let errors = [ ];
                let _this = $(this);
                let ctrl = _this.data('ctrl');
                let productId = _this.data('product-id');

                if (validate_empty.validate(e, null, null, $('.modal')) == true) {
                    return false;
                }

                // Проверка за празна доставна цена
                if (v.$modal.find('input#priceDostavna').val( ) == 0) {
                    //Искате ли да запишете нов продукт без доставна цена?
                    if (! confirm(LANGpop__editProduct.confirm.saveWithEmptyDostPrice)) {
                        return false;
                    }
                }

                // Проверка на мерни единици
                v.$modal.find('.js-isFocus').each(function () {

                    const $input = $(this);
                    const label = $input.data('label') || 'поле';
                    const $unit = $input.parents('.input-group').find('select').eq(0);

                    const valueFilled = $input.val().trim() !== '';
                    const unitFilled = $unit.val() && $unit.val().trim() !== '';

                    // Ако има стойност, но няма мерна единица
                    if (valueFilled && ! unitFilled) {
                        errors.push(label);
                    }
                });

                if (errors.length > 0) {
                    msg = 'Моля, изберете мярка за:\n';
                    errors.forEach(function (label) {
                        msg += '• ' + label + '\n';
                    });

                    alert(msg);
                    return false;
                }

                $(document).off('submit').on('submit', 'form', function (e) {
                    e.preventDefault( );
                    var route = $(this).attr('action');

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: $(this).serializeJSON({checkboxUncheckedValue: ""}),
                        dataType: 'json',
                        success: function (response) {

                            if (response.err) {
                                alert(response.err);
                                return false;
                            }

                            if (response.dub === true) {
                                alert(response.data);
                                return false;
                            }

                            // ако създаваме нов продулкт в списък продукти се презарежда стр.
                            if (response.spProduct === true || response.reload === true) {
                                history.go(0);
                                return false;
                            }

                            if (response.edit === true) {
                                //$(v.table).find('tbody tr[data-id =' + productId + ']').replaceWith(response.data);

                                if (response.reload === true) {
                                    history.go(0);
                                    return false;
                                }

                                $(v.table + ' tbody').load(window.location.href + ' ' + v.table + ' tbody>*', function (response, status, xhr) {
                                    if (typeof $root !== 'undefined') {
                                        $root.plugins();
                                    }
                                });
                            }

                            // ако създаваме нов продукт в офертата
                            if (response.isNew === true && response.data != '') {
                                if (ctrl === 'zenova' && productId === '' || confirm(LANGpop__editProduct.confirm.add_product)) {
                                    // Добавяне на новосъздадения продукт към офертата
                                    $(v.table).find('tbody').append(response.data);
                                }
                            }

                            $('.modal').modal('toggle');

                            if (typeof $root !== 'undefined') {
                                $root.plugins();
                            }
                        }
                    });
                    e.stopImmediatePropagation( );
                });
            },

            'ckfinder': function (e) {
                const $this = $(this);
                const role = $this.data('role') || '';
                const section = $this.closest('section');
                const isBrand = $this.data('isBrand');
                const brandId = section.find('#brandId:hidden').val();
                const modelId = section.find('#brand_model_id:hidden').val();
                const plugins = config.pluginsPatch + '/' + config.plugins;
                let startupPath = '';
                // Дефинираме проверки за всяка роля
                const roleChecks = {
                    '_brand': {
                        id: brandId,
                        message: 'Изберете марка преди да присвоите картинка.',
                        confirmMsg: 'Сигурни ли сте, че искате да присвоите снимка към избраната марка?',
                        startupPath: 'productImages:/_brand/'
                    },
                    '_models': {
                        id: modelId,
                        message: 'Изберете главен модел преди да присвоите картинка.',
                        confirmMsg: 'Сигурни ли сте, че искате да присвоите снимка към главният модел?',
                        startupPath: 'productImages:/_models/'

                    }
                };

                // Прилага се проверката, ако ролята е brand или model
                if (roleChecks[role]) {
                    const {id, message, confirmMsg, startupPath: path} = roleChecks[role];

                    startupPath = path;

                    if (! id) {
                        alert(message);
                        return false;
                    }

                    if (! confirm(confirmMsg)) {
                        return false;
                    }
                }

                CKFinder.popup({
                    id: role,
                    chooseFiles: true,
                    skin: 'jquery-mobile',
                    language: 'bg',
                    swatch: 'b',
                    width: 1024,
                    height: 800,
                    rememberLastFolder: startupPath != '' ? false : true,
                    startupFolderExpanded: true,
                    startupPath: startupPath || '',
                    plugins: [ plugins ],
                    onInit: function (finder) {
                        finder.config.extraPlugins = 'Image_modificate';

                        finder.on('files:choose', function (evt) {
                            var file = evt.data.files.first( );
                            var avatar = $this;
                            var newPatch = file.getUrl( ).replace(GLOBVAR.productImageBaseDir, '');

                            avatar.find('img').attr('src', file.getUrl( ));
                            avatar.find('.avatar').attr('value', newPatch);
                            avatar.find('.camera').removeClass('fa-camera w-100 m-auto');
                            if (role == '_brand' || role == '_models') {
                                $.ajax({
                                    url: $this.data('route'),
                                    type: 'POST',
                                    data: {'role': role, 'brandId': brandId, 'modelId': modelId, 'image_path': newPatch},
                                    dataType: 'json',
                                    success: function (response) {
                                        if (response.err) {
                                            alert(response.err);
                                            return false;
                                        }

                                        alert('Снимката е присвоена към избраната марка.');
                                    }
                                });
                            }
                        });

                        finder.on('file:choose:resizedImage', function (evt) {
                            $this.attr('src', evt.data.resizedUrl);
                        });
                    }
                });
                e.stopImmediatePropagation( );
            }
        }
    };
    popup_product_edit.init( );
} )(jQuery, window, document);
