/* global loadPlugins */

( function ($, window, document, undefined) {

    var popup_language = popup_language || {};
    let v = popup_language;

    popup_language = {
        '__var': {
            $modal: $('#' + $('.modal').attr('id')),
            $table: 'tbl_valuta'
        },
        'init': function ( ) {
            v = this.__var;

            this.setUpListeners( );
        },

        'setUpListeners': function ( ) {

            //BTN
            v.$modal.on('click', 'tbody input.isDefault', this.btn.set_defaultLanguage);
            v.$modal.on('click', 'tbody td.action .edit', this.btn.edit);
            v.$modal.on('click', '.action .save', this.btn.save);
            v.$modal.on('click', 'tbody td.action .delete', this.btn.delete);
            v.$modal.on('click', 'tbody td.action .cansel', this.btn.cansel);
        },

        'btn': {
            'set_defaultLanguage': function (e) {
                var _this = $(this);
                var $tr = _this.closest('tr');

                $.ajax({
                    url: _this.data('route'),
                    type: 'POST',
                    data: {'code': $tr.find('input[name=language_code]').val(), 'isDefault': $(this).val()},
                    dataType: 'json',
                    success: function (response) {
                        history.go(0);
                    }
                });

                e.stopImmediatePropagation();
            },

            'edit': function (e) {
                var _this = $(this);
                var $tr = _this.closest('tr');

                $tr.find('input[type=hidden]:not(.id)').attr('type', 'text');
                $tr.find('span').hide( );
                $tr.find('.btnGroup1').addClass('hide');
                $tr.find('.btnGroup2').removeClass('hide');

                e.stopImmediatePropagation();
            },

            'cansel': function (e) {
                var _this = $(this);
                var $tr = _this.closest('tr');

                $tr.find('input[type=text]').attr('type', 'hidden');
                $tr.find('span').show( );
                $tr.find('.btnGroup1').removeClass('hide');
                $tr.find('.btnGroup2').addClass('hide');

                e.stopImmediatePropagation();
            },

            'save': function (e) {
                var _this = $(this);
                var table = _this.closest('table');
                var $tr = _this.closest('tr');


                $.ajax({
                    url: _this.data('route'),
                    type: 'POST',
                    data: {'form': $tr.find('input').serializeJSON( )},
                    dataType: 'json',
                    success: function (response) {
                        if (response != '') {
                            table.find('tbody').html(response);
                        }

                        table.find('thead input').val('');
                    }
                });

                e.stopImmediatePropagation();
            },

            'delete': function (e) {
                var _this = $(this);
                var $tr = _this.closest('tr');
                var name = _this.data('name');

                if (!confirm(LANGpop__language.confirm.delete + ' ' + name)) {
                    return false;
                }

                $.ajax({
                    url: _this.data('route'),
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        $tr.remove();
                        alert(response);
                    }
                });

                e.stopImmediatePropagation();
            }
        }
    };
    popup_language.init( );

} )(jQuery, window, document);

