/* global loadPlugins, tableActions */

( function ($, window, document, undefined) {

    var popup_returnOrder = popup_returnOrder || {};
    let v = popup_returnOrder;

    popup_returnOrder = {
        '__var': {
            $modal: $('#' + $('.modal').attr('id')),
        },
        'init': function ( ) {
            v = this.__var;

            this.plugins( );
            this.setUpListeners( );
        },
        'plugins': function ( ) {
            Lp = loadPlugins;
            Ta = tableActions;

            Ta.table.filter({'input': '#filter', 'modal': '#' + $('.modal').attr('id'), 'table': '#' + v.$modal.find('.table').attr('id')}); // филтър
        },

        'setUpListeners': function ( ) {

            //EVENTS
            v.$modal.on('input', 'tbody .returnQty', this.event.change_returnQty);

            //BTN
            v.$modal.on('click', '#save', this.btn.save);

        },

        'event': {
            // проверка на връщаното количество
            'change_returnQty': function (e) {
                e.stopImmediatePropagation();
                let _this = $(this);
                let qty = _this.parent('td').find('.qty').val();

                // ако кол. което връщаме в по > от поръчаното 
                if (_this.val() > qty) {
                    _this.val(qty);
                }
                else if (_this.val() <= 0) {
                    _this.val('');
                }
            }
        },

        'btn': {

            'save': function (e) {
                e.stopImmediatePropagation();

                $(document).off('submit').on('submit', 'form', function (e) {
                    e.preventDefault( );
                    const route = $(this).attr('action');
                    var form = $(this);

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: form.serializeJSON( ),
                        dataType: 'json',
                        success: function (response) {

                            if (response.err) {
                                alert(response.err);
                                return false;
                            }

                            $("#tbl_products").load(window.location + ' #tbl_products>*', function (response, status, xhr) {
                                $root.plugins();
                            });

                            $('.modal').modal('toggle');
                        }
                    });

                })




            }
        }
    };
    popup_returnOrder.init( );
} )(jQuery, window, document);

