/* global LANGpop__izborProduct, tableActions, loadPlugins */
( function ($, window, document, undefined) {

    var popup_toSite = popup_toSite || {};
    let v = popup_toSite;

    popup_toSite = {
        '__var': {
            table: $("#tbl_products"),
            $modal: $('#' + $('.modal').attr('id'))
        },
        'init': function () {
            v = this.__var;
            Lp = loadPlugins;
            Ta = tableActions;

            Lp.table_freezeHeader({'table': v.$modal.find('table'), 'left': 'auto', 'scroll': v.$modal.find('.overflow-auto'), 'margin': 0}); // thead frezze
            Ta.table.filter({'input': '#filter', 'modal': '#' + $('.modal').attr('id'), 'table': '#' + v.$modal.find('.table').attr('id')}); // филтър

            this.setUpListeners();
        },
        'setUpListeners': function ( ) {
            //EVENTS  
            v.$modal
                    .on('change', '.chk_all', this.event.chk_all)
                    .on('change', '.d,.k', this.event.change_single_chkToSite);


            // БУТОНИ   
            v.$modal
                    .on('click', '#save', this.btn.save);

        },

        'event': {
            // за промяна на всички чекбоксове
            'chk_all': function (e) {
                e.stopImmediatePropagation();
                var _this = $(this);
                var index = _this.data('index');
                let tip = _this.data('tip');
                var isChecked = _this.is(":checked");
                var route = _this.closest('table').data('route');
                var form = $('#form_toSite');
                var inputChecked = v.$modal.find('tbody tr input[type=checkbox]');

                if (!confirm(`Сигурни ли сте, че искате да добавите  всички продукти видими само за ${tip === 'd' ? 'дилър' : 'клиент'} към избраният сайт?`)) {
                    _this.prop('checked', false);
                    return false;
                }

                _this.closest('table').find(`tbody td[data-index="${index}"] input[type="checkbox"].${tip}:visible`).prop('checked', isChecked);

                $.ajax({
                    url: route,
                    type: "POST",
                    data: {'form': form.serializeJSON({checkboxUncheckedValue: ''})},
                    dataType: 'json',
                    success: function (response) {

                        if (response.message) {
                            alert(response.message);
                        }

                        inputChecked.each(function () {
                            var tr = $(this).closest('tr');
                            var length = tr.find('input:checked').length;
                            var productId = tr.data('id');
                            var targetRow = $(`#tbl_products tbody tr[data-id="${productId}"]`);

                            targetRow.find('input.toSite').prop('checked', length > 0);
                        });
                    }
                });
            },

            // чекбоксове single за добавяне /премахване към /от сайт
            'change_single_chkToSite': function (e) {
                e.stopImmediatePropagation();
                var _this = $(this);
                var tr = _this.closest('tr');
                var td = _this.closest('td').find(':input');
                var length = tr.find('input:checked').length;
                var productId = tr.data('id');
                var targetRow = $('#tbl_products tbody tr[data-id="' + productId + '"]');
                var toSiteCheckbox = targetRow.find('input.toSite');
                var route = _this.closest('table').data('route');

                $.ajax({
                    url: route,
                    type: "POST",
                    data: {'form': td.serializeJSON({checkboxUncheckedValue: ''})},
                    dataType: 'json',
                    success: function (response) {
                        toSiteCheckbox.prop('checked', length > 0);
                    }
                });
            },
        },

        'btn': {

            'save': function () {
                var form = $('#form_toSite');
                var inputChecked = v.$modal.find('tbody tr input[type=checkbox]');

                $.ajax({
                    url: $(this).data('route'),
                    type: "POST",
                    data: {'form': form.serializeJSON({checkboxUncheckedValue: ''})},
                    dataType: 'json',
                    success: function (response) {

                        if (response.message) {
                            alert(response.message);
                        }

                        inputChecked.each(function () {
                            var tr = $(this).closest('tr');
                            var length = tr.find('input:checked').length;
                            var productId = tr.data('id');
                            var targetRow = $('#tbl_products tbody tr[data-id="' + productId + '"]');
                            var toSiteCheckbox = targetRow.find('input.toSite');

                            toSiteCheckbox.prop('checked', length > 0);
                        });
                    }
                });
            }
        }
    };

    popup_toSite.init();

} )(jQuery, window, document);
