/* global LANGpop__izborProduct, loadPlugins, $root, SETTINGS_DDS, tableActions */

( function ($, window, document) {
    var popup_zenoobrazuvane = popup_zenoobrazuvane || {};
    let v = popup_zenoobrazuvane;
    let $self = popup_zenoobrazuvane;

    popup_zenoobrazuvane = {
        '__var': {
            $modal: $('#' + $('.modal').attr('id')),
            modalTable: '.modal' + ' #' + $('#' + $('.modal').attr('id')).find('.table').attr('id')
        },
        'init': function () {
            v = this.__var;
            $self = this;

            this.plugins();
            this.setUpListeners();
            this.autoNadzenka();
        },
        'plugins': function () {
            Lp = loadPlugins;
            Ta = tableActions;

            //Lp.lazyLoadTableRows({'isModal': true, 'modal': '.modal', 'bodyHeight': '.modal-body', 'tableId': '#tbl_zenoobr'});
            Lp.popupTitle();
            Lp.table_freezeHeader({'table': v.modalTable, 'scroll': '.overflow-auto', 'margin': 0}); // thead frezze
            Ta.table.filter({'input': '#filter', 'modal': '#' + $('.modal').attr('id'), 'table': '#' + v.$modal.find('.table').attr('id')}); // филтър
        },
        'setUpListeners': function ( ) {

            // EVENTS 
            v.$modal.on('keyup', 'thead:not(.tableFloatingHeader) .percent', this.events.change_percent)
                    .on('keyup', 'thead .masPrice', this.events.change_masPrice)
                    .on('keyup', 'tbody input.A2, tbody input.kkc', this.events.change_cell)
                    .on('keyup', 'tbody input.dostCena', this.events.change_dostZena);


            // БУТОНИ 
            v.$modal.on('click', '#hide_image', this.btn.hideImage)
                    .on('click', '#fixedToFirstNum', this.btn.fixedToFirstNum)
                    .on('click', 'input[type=radio]', this.btn.radios)
                    .on('click', '#resumZenoobr', this.btn.resum)
                    .on('click', '#save', this.btn.save);
        },

        // при отваряне на модал ф. авт надценка
        'autoNadzenka': function () {

            $(document).ready(() => {
                var radios = v.$modal.find('.modal-footer ul input[type=radio]:checked');
                var isRoundedToFirst = v.$modal.find('.modal-footer input#fixedToFirstNum:checked');

                if (isRoundedToFirst.length) {
                    isRoundedToFirst.click().click(); // dali e закръгляне до 1-я знак
                }

                radios.trigger("click");

                if (radios.val() !== 'manual') {
                    v.$modal.find('thead:not(.tableFloatingHeader) input.percent').trigger('keyup'); // клетки %
                }
                else if (radios.val() === 'manual') {
                    v.$modal.find('tbody input.A2, tbody input.kkc ').trigger('keyup'); // клетки цена
                }
            });
        },

        'events': {
            // обща цена в thead за всяка колона
            'change_masPrice': function (e) {
                e.stopImmediatePropagation();

                let _this = $(this);
                let inputValue = Number(_this.val()) || 0;
                let $table = _this.closest('table');
                let percentData = _this.data('percent');
                let key = e.keyCode || e.which;
                const isCheckedFixedToFirst = v.$modal.find('#fixedToFirstNum').is(":checked");
                let roundedValue = isCheckedFixedToFirst ? inputValue.toFixed(1) : Lp.toFixed(inputValue);
                //ако е натиснат tab,дясна или лява стрелка
                if ([ 9, 37, 39 ].includes(key)) {
                    return false;
                }

                $table.find(`tbody tr input[data-percent="${percentData}"]:visible`).each(function () {
                    $(this).val(roundedValue).attr('value', roundedValue).trigger('keyup');
                });
            },

            'change_percent': function (e) {
                var $table = $(this).closest('table');
                var radios = v.$modal.find('.modal-footer ul input[type=radio]:checked');
                var percentVal = Number(this.value);
                var percentData = $(this).data('percent');
                var percent = percentVal / 100;
                var nadzData = $(this).data('nadz');
                var razlika = '';
                var nadz = '';
                var key = e.keyCode || e.which;

                //ако е натиснат tab,дясна или лява стрелка
                if ([ 9, 37, 39 ].includes(key)) {
                    return false;
                }

                // Ако стойността е празна
                if (this.value === '') {
                    if (e.isTrigger === undefined) {
                        $table.find(`tbody td.${nadzData}`).removeClass('bg-red').text('');
                        $table.find(`tbody input[data-percent=${percentData}]`).val('');
                    }
                    return false;
                }

                $table.find('tbody tr').each(function () {
                    let row = $(this);
                    let dostCena = Number(row.find('.dostCena').val());
                    let price_kkc = Number(row.find('.kkc').val());
                    let isAutoRadio = radios.val() === 'auto';
                    let inputEl = '';
                    let nadzKkc = '';

                    price_kkc /= SETTINGS_DDS;
                    razlika = price_kkc - ( price_kkc * percent );
                    nadz = ( ( razlika - dostCena ) / dostCena ) * 100;

                    if (radios.val() === 'auto') {
                        nadzKkc = ( ( price_kkc - dostCena ) / dostCena ) * 100;
                        row.find(`td.${nadzData}`).text(`${Lp.toFixed(nadzKkc)} %`);
                    }
                    else if (radios.val() === 'nadzenka') {
                        razlika = dostCena + ( dostCena * percent );
                        nadz = percentVal;

                        if (percentData === 'percentKkc') {
                            razlika *= SETTINGS_DDS;
                        }
                        row.find(`td.${nadzData}`).text(`${Lp.toFixed(nadz)} %`);
                    }

                    razlika = isNaN(razlika) ? 0 : Lp.toFixed(razlika);
                    nadz = ( isNaN(nadz) || nadz === 0 ) ? '' : Lp.toFixed(nadz) + ' %';

                    inputEl = row.find(`input[data-percent=${percentData}]`);
                    // ако е тригер keyup от resum ако е колона ккц се пропуска
                    if ($.isNumeric(e.isTrigger) && ( percentData !== 'percentKkc' || radios.val() === 'nadzenka' )) {
                        inputEl.val(razlika).attr('value', razlika);
                    }
                    else if (!$.isNumeric(e.isTrigger)) {
                        inputEl.val(razlika).attr('value', razlika);
                    }

                    row.find(`td.${nadzData}:not(.nadzKkc)`).text(nadz);

                    if (( isAutoRadio && nadzData !== 'nadzKkc' ) || !isAutoRadio) {
                        $self.events.is_negativeNadz(this, parseFloat(nadz), nadzData, dostCena);
                    }

                });
                // event.stopImmediatePropagation();
            },

            // при промяна на клетка когато сме в ръчен режим
            'change_cell': function (e) {
                const _this = $(this);
                const $tr = _this.closest('tr');
                const $radioAuto = v.$modal.find('.modal-footer #auto');
                const nadzData = _this.data('nadz');
                const dostCena = Number($tr.find('.dostCena').val());
                let nadz = 0;
                const key = e.keyCode || e.which;

                //ако е натиснат tab,дясна или лява стрелка
                if ([ 9, 37, 39 ].includes(key)) {
                    return false;
                }

                if (!$radioAuto.is(':checked') && this.value === '') {
                    $tr.find(`td.${nadzData}`).removeClass('bg-red').text('');
                }
                else {
                    var isKkc = ( nadzData === 'nadzKkc' && this.value !== '' ) ? this.value / SETTINGS_DDS : this.value;

                    nadz = ( ( isKkc - dostCena ) / dostCena ) * 100;

                    if ($radioAuto.is(':checked') && nadzData === 'nadzKkc') {
                        processNadz.call(this, isKkc, nadz);
                    }
                    else {
                        $tr.find(`td.${nadzData}`).text(`${Lp.toFixed(nadz)} %`);

                        // проверка дали надц. е отрицателна
                        $self.events.is_negativeNadz(this, nadz, nadzData, dostCena);
                    }
                }

                // обща ф-я
                function processNadz (isKkcValue, nadzKkcVal) {

                    if (isKkcValue === '') {
                        $tr.find('input[data-percent]').val('').attr('value', '');
                        $tr.find('td.A1').removeClass('bg-red').text('');
                        return false;
                    }

                    $(this).closest('table')
                            .find('thead:not(.tableFloatingHeader) tr:not(.header) th div.A00 input')
                            .each((index, el) => {
                                let percent = el.value / 100;
                                let percentData = $(el).data('percent');
                                let nadzData = $(el).data('nadz');
                                let razlika = isKkcValue - ( isKkcValue * percent );

                                nadz = ( ( razlika - dostCena ) / dostCena ) * 100;

                                $tr.find(`input[data-percent=${percentData}]`).val(Lp.toFixed(razlika)).attr('value', razlika);
                                $tr.find(`td.${nadzData}`).text(`${Lp.toFixed(nadz)} %`);

                                // проверка дали надц. е отрицателна
                                $self.events.is_negativeNadz(_this, nadz, nadzData, dostCena);
                            });

                    $tr.find('td.nadzKkc').text(`${Lp.toFixed(nadzKkcVal)} %`);

                    // проверка дали надц. е отрицателна
                    $self.events.is_negativeNadz(_this, nadzKkcVal, 'nadzKkc', dostCena);
                }

                $(this).blur(() => {
                    const thisValue = this.value;

                    if (thisValue && thisValue % 1 !== 0) {
                        const decimalCount = thisValue.split(".")[1].length;

                        if (decimalCount !== SETTINGS_NUM_FIXED) {
                            this.value = Lp.toFixed(this.value);
                            $(this).trigger('keyup');
                        }
                    }
                });
            },

            // ако надценката е с отрицателен знак
            'is_negativeNadz': function (e, nadz, nadzClass, dostCena) {
                const $tr = $(e).closest('tr');
                const dangerClass = 'bg-red';
                const nadzTd = $tr.find(`td.${nadzClass}`);

                ( nadz < 0 && nadz !== '' )
                        ? nadzTd.addClass(dangerClass)
                        : nadzTd.removeClass(dangerClass);
            },

            // промяна на дост цена
            'change_dostZena': function () {
                var $tr = $(this).closest('tr');

                $tr.find('input.kkc').trigger('keyup');
                event.stopImmediatePropagation();
            }
        },

        'btn': {
            // закръгляне до 1-я знак
            'fixedToFirstNum': function (e) {
                let _this = $(this);
                const isChecked = _this.is(":checked");

                if (!$.isNumeric(e.isTrigger)) {
                    if (isChecked && !confirm('Сигурнили сте, че искате да закръглите всички цени до 1-я знаk?')) {
                        return false;
                    }
                }

                $(v.modalTable).find('tbody tr').each(function () {
                    $(this).find('input.kkc, input.A2').each(function () {
                        let $input = $(this);
                        let roundedValue = isChecked ? ( parseFloat($input.val()) || 0 ).toFixed(1) : Lp.toFixed($input.val());

                        $input.val(roundedValue);
                    });
                });
            },

            'hideImage': function () {
                const isChecked = $(this).is(":checked");

                v.$modal.find('thead:not(.tableFloatingHeader) th.img,tbody td.img ').toggle(!isChecked);
                event.stopImmediatePropagation();
            },

            // методи на ценообр
            'radios': function (е) {
                const $table = v.$modal.find('table');
                const tbody = $table.find('tbody');
                const thead = $table.find('thead:not(.tableFloatingHeader)');
                const headerTitle = v.$modal.find('.modal-header .modal-title');
                const btnResum = v.$modal.find('.modal-footer #resumZenoobr');

                const showMessage = message => alert(message);

                const handleSwitch = (id, title, showFooter) => {
                    const isAutoOrNadzenka = id === 'nadzenka' || id === 'auto';
                    const isNadzenka = id === 'nadzenka';

                    headerTitle.text(title);
                    btnResum.toggle(showFooter);

                    thead.find('.A00').toggle(isAutoOrNadzenka);
                    thead.find('.A0').toggle(isNadzenka);
                    thead.find('.masPrice').toggleClass('hide', [ 'manunal', 'auto', 'nadzenka' ].includes(id));
                    tbody.find('td').removeClass('bg-red');
                    tbody.find('.A2').toggleClass('pointer-events-none', isAutoOrNadzenka);
                    tbody.find('.kkc').toggleClass('pointer-events-none', isNadzenka);
                    tbody.find('.A1').text('');

                    if (е.isTrigger === undefined) {
                        showMessage(LANGpop__zenoobr.alert['metod' + id.charAt(0).toUpperCase() + id.slice(1)]);
                    }
                };

                switch (this.id) {
                    case 'nadzenka':
                        handleSwitch(this.id, LANGpop__zenoobr.titleNadz, true);
                        break;

                    case 'auto':
                        handleSwitch(this.id, LANGpop__zenoobr.titleAuto, true);
                        break;

                    case 'manual':
                        handleSwitch(this.id, LANGpop__zenoobr.titleManual, false);
                        tbody.find('.A2').css({'background': '#ffb1b1'});
                        break;
                }

                е.stopImmediatePropagation();
            },

            // бутон преизчисли
            'resum': function (e) {

                const confirmMsg = LANGpop__zenoobr.confirm.recalculate;
                const successMsg = LANGpop__zenoobr.alert.completeRecalculate;

                if (confirm(confirmMsg)) {
                    $(v.modalTable + ' thead:not(.tableFloatingHeader)')
                            .find('tr:not(.header) input.percent')
                            .each((index, el) => {
                                $(el).trigger('keyup');
                            });

                    alert(successMsg);
                }

                e.stopImmediatePropagation();
            },

            // запис в БД 
            'save': function () {
                const confirmm = confirm(LANGpop__zenoobr.confirm.save); // Сигурни ли сте че искате да промените \nценовите данни на всички продукти

                if (!confirmm) {
                    return false;
                }

                $(document).off('submit').on('submit', 'form', function (e) {
                    e.preventDefault();
                    e.stopImmediatePropagation();
                    const route = $(this).attr('action');

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {form: JSON.stringify($(this).serializeJSON())},
                        dataType: 'json',
                        success: response => {
                            if (response.err) {
                                alert(response.err);
                                return false;
                            }

                            $("#tableProduct").load(window.location + ' #tableProduct>*', function (response, status, xhr) {
                                $root.plugins();
                            });

                            $('.modal').modal('toggle');
                        }
                    });
                });
            }
        }
    };
    popup_zenoobrazuvane.init();

}(window.jQuery, window, document) );

