/* global LANGpop__izborProduct, loadPlugins, $root, SETTINGS_DDS, tableActions */
( function ($, window, document) {

    var popup_zenoobrazuvanePrivate = popup_zenoobrazuvanePrivate || {};
    let v = popup_zenoobrazuvanePrivate;
    let $self = popup_zenoobrazuvanePrivate;

    popup_zenoobrazuvanePrivate = {
        '__var': {
            $modal: $('#' + $('.modal').attr('id')),
            modalTable: '.modal' + ' #' + $('#' + $('.modal').attr('id')).find('.table').attr('id')
        },
        'init': function () {
            v = this.__var;
            $self = this;

            this.plugins();
            this.setUpListeners();
            this.autoNadzenka();
        },
        'plugins': function () {
            Lp = loadPlugins;
            Ta = tableActions;

            Lp.selectpicker( );
            Lp.popupTitle();
            Lp.table_freezeHeader({'table': v.modalTable, 'scroll': '.overflow-auto', 'margin': 0}); // thead frezze
            Ta.table.filter({'input': '#filter', 'modal': '#' + $('.modal').attr('id'), 'table': '#' + v.$modal.find('.table').attr('id')}); // филтър
        },
        'setUpListeners': function ( ) {

            // EVENTS 
            v.$modal
                    .on('keyup', '.bs-searchbox input', this.events.klient_autocomplete)
                    .on('keyup', 'thead:not(.tableFloatingHeader) .percent', this.events.change_percent)
                    .on('keyup', 'tbody input.A2', this.events.change_cell);


            // БУТОНИ 
            v.$modal
                    .on('click', 'input[type=radio]', this.btn.radios)
                    .on('click', '.fa-minus-circle', this.btn.removeItem)
                    .on('click', '#hide_image', this.btn.hideImage)
                    .on('click', '.fixedToFirstNum', this.btn.fixedToFirstNum)
                    .on('click', '#save', this.btn.save);
        },

        // при отваряне на модал ф. авт надценка
        'autoNadzenka': function () {

            $(document).ready(function () {
                var radios = v.$modal.find('.modal-footer ul input[type=radio]:checked');

                radios.trigger("click");

                if (radios.val() !== 'manual') {
                    v.$modal.find('thead:not(.tableFloatingHeader) input.percent').trigger('keyup'); // клетки %
                }
                else if (radios.val() === 'manual') {
                    v.$modal.find('tbody input.A2').trigger('keyup'); // клетки цена
                }
            });
        },

        'events': {
            'klient_autocomplete': function (e) {
                e.stopImmediatePropagation();

                const _this = $(this);
                let route = _this.closest('.bootstrap-select').find('#klient_name');
                let keycode = ( e.keyCode ? e.keyCode : e.which );

                if ([ 40, 38, 13, 37, 39, 18, 16 ].includes(keycode)) {
                    return false;
                }

                // ако input полето е празно
                if (_this.val().length == 0) {
                    route.empty().selectpicker('refresh');
                    return false;
                }

                $.ajax({
                    url: route.data('route'),
                    type: "GET",
                    global: false,
                    data: {'text': _this.val().trim()},
                    dataType: 'json',
                    success: function (response)
                    {

                        let options = response.reduce(function (html, value) {
                            let isDisabled = $('#klient-box').find(`[data-klient-id="${value.klient_id}"]`).length > 0 ? 'disabled' : '';
                            return html + `<option value='${value.klient_id}' ${isDisabled}>${value.klient_name}</option>`;
                        }, '');

                        route.html(options).selectpicker('refresh');
                    }
                });

                // когато изберем клиент от списъка autocomplete
                route.on('changed.bs.select', function (e, clickedIndex, isSelected, previousValue) {
                    let selectedValue = route.val().pop();
                    let selectedText = route.find(`option[value="${selectedValue}"]`).text();

                    // Check if the value is selected and not already in the klient-box
                    if (isSelected && selectedValue && !$('#klient-box').find(`[data-klient-id="${selectedValue}"]`).length) {
                        $self.func_addItem('#klient-box', selectedText, 'klientIds[]', selectedValue);
                        route.find(`option[value="${selectedValue}"]`).prop('disabled', true);
                        route.selectpicker('refresh');
                    }
                });

                route.on('hide.bs.select', function () {
                    route.empty().selectpicker('refresh');// премахване на autocomplete списъка
                });
            },

            'change_percent': function (e) {
                var $table = $(this).closest('table');
                var fixedToFirstNum = v.$modal.find('.modal-footer .fixedToFirstNum:checked');
                let percentVal = parseFloat(this.value) || 0;
                var percentData = $(this).data('percent');
                var percent = percentVal / 100;
                var nadzData = $(this).data('nadz');
                var rowsToProcess = $.isNumeric(e.isTrigger) ? $table.find('tbody tr') : $table.find('tbody tr:visible');
                var razlika = '';
                var nadz = '';
                var key = e.keyCode || e.which;

                //ако е натиснат tab,дясна или лява стрелка
                if ([ 9, 37, 39 ].includes(key)) {
                    return false;
                }

                // Ако стойността е празна
                if (!percentVal) {
                    if (!$.isNumeric(e.isTrigger)) {
                        $table.find(`tbody td.${nadzData}`).removeClass('bg-red').text('');
                    }
                    return false;
                }

                rowsToProcess.each(function () {
                    let row = $(this);
                    let dostCena = Number(row.find('.dostCena').val());
                    let price_kkc = Number(row.find('.A2').val());
                    let decimalPart = 0;

                    if (fixedToFirstNum.length && fixedToFirstNum.val() !== undefined) {
                        decimalPart = fixedToFirstNum.val();
                    }
                    else if (price_kkc % 1 !== 0) {
                        decimalPart = price_kkc.toString().split('.')[1].length;
                    }

                    razlika = dostCena + ( dostCena * percent );
                    nadz = percentVal;

                    razlika = isNaN(razlika) ? 0 : razlika.toFixed(decimalPart);
                    nadz = ( isNaN(nadz) || nadz === 0 ) ? '' : Lp.toFixed(nadz) + ' %';

                    row.find(`input[data-percent=${percentData}]`).val(razlika).attr('value', razlika);
                    row.find(`td.${nadzData}`).text(`${Lp.toFixed(nadz)} %`);
                    $self.events.is_negativeNadz(this, parseFloat(nadz), nadzData, dostCena);
                });
            },

            // при промяна на клетка когато сме в ръчен режим
            'change_cell': function (e) {
                const _this = $(this);
                const $tr = _this.closest('tr');
                const $radioAuto = v.$modal.find('.modal-footer #auto');
                const nadzData = _this.data('nadz');
                const dostCena = Number($tr.find('.dostCena').val());
                let nadz = 0;
                const key = e.keyCode || e.which;

                //ако е натиснат tab,дясна или лява стрелка
                if ([ 9, 37, 39 ].includes(key)) {
                    return false;
                }

                if (this.value === '') {
                    $tr.find(`td.${nadzData}`).removeClass('bg-red').text('');
                }
                else {
                    nadz = ( ( this.value - dostCena ) / dostCena ) * 100;
                    $tr.find(`td.${nadzData}`).text(`${Lp.toFixed(nadz)} %`);

                    // проверка дали надц. е отрицателна
                    $self.events.is_negativeNadz(this, nadz, nadzData, dostCena);
                }

                $(this).blur(() => {
                    const thisValue = this.value;

                    if (thisValue && thisValue % 1 !== 0) {
                        const decimalCount = thisValue.split(".")[1].length;

                        if (decimalCount !== SETTINGS_NUM_FIXED) {
                            this.value = Lp.toFixed(this.value);
                            $(this).trigger('keyup');
                        }
                    }
                });
            },

            // ако надценката е с отрицателен знак
            'is_negativeNadz': function (e, nadz, nadzClass, dostCena) {
                const $tr = $(e).closest('tr');
                const dangerClass = 'bg-red';
                const nadzTd = $tr.find(`td.${nadzClass}`);

                ( nadz < 0 && nadz !== '' )
                        ? nadzTd.addClass(dangerClass)
                        : nadzTd.removeClass(dangerClass);
            },

        },

        'btn': {
            // методи на ценообр
            'radios': function (е) {
                const $table = v.$modal.find('table');
                const tbody = $table.find('tbody');
                const thead = $table.find('thead:not(.tableFloatingHeader)');
                const headerTitle = v.$modal.find('.modal-header .modal-title');
                const btnResum = v.$modal.find('.modal-footer #resumZenoobr');

                const showMessage = message => alert(message);

                const handleSwitch = (id, title, showFooter) => {
                    const isNadzenka = id === 'nadzenka';

                    headerTitle.text('ИНДИВИДУАЛНО ' + title);

                    tbody.find('.A1').text('');
                    thead.find('.A00').toggle(isNadzenka);
                    tbody.find('td').removeClass('bg-red');
                    tbody.find('.A2').toggleClass('pointer-events-none', isNadzenka);

                    if (!$.isNumeric(е.isTrigger)) {
                        showMessage(isNadzenka ? 'Избран е метод ценообразуване с надценка!' : 'Избран е метод ценообразуване ръчно');
                    }
                };

                switch (this.id) {
                    case 'nadzenka':
                        handleSwitch(this.id, LANGpop__zenoobr.titleNadz, true);
                        break;

                    case 'manual':
                        v.$modal.find('thead:not(.tableFloatingHeader) input.percent').val('');
                        handleSwitch(this.id, LANGpop__zenoobr.titleManual, false);
                        tbody.find('.A2').css({'background': '#ffb1b1'});
                        v.$modal.find('tbody input.A2').trigger('keyup'); // клетки цена
                        break;
                }

                е.stopImmediatePropagation();
            },

            // премахване на клиент от списъка
            'removeItem': function () {
                $(this).parent().remove();
            },

            // закръгляне до 1-я знак
            'fixedToFirstNum': function (e) {
                let _this = $(this);
                const isChecked = _this.is(":checked");
                let checkedValue = $(this).val();


                if (isChecked) {
                    if (!confirm(`Сигурнили сте, че искате да закръглите всички цени до ${checkedValue}-я знаk?`)) {
                        return false;
                    }

                    $(v.modalTable).find('tbody tr').each(function () {
                        $(this).find('input.A2').each(function () {
                            let $input = $(this);
                            let roundedValue = isChecked ? ( parseFloat($input.val()) || 0 ).toFixed(checkedValue) : Lp.toFixed($input.val());

                            $input.val(roundedValue);
                        });
                    });
                }
            },

            'hideImage': function () {
                const isChecked = $(this).is(":checked");

                v.$modal.find('thead:not(.tableFloatingHeader) th.img,tbody td.img ').toggle(!isChecked);
                event.stopImmediatePropagation();
            },

            // запис в БД 
            'save': function () {
                if ($('#klient-box').children().length == 0 && !confirm('Внимание продължавате ли без да е избран клиент?')) {
                    return false;
                }

                if (!confirm('Сигурни ли сте, че искате да запишете промените?')) {
                    return false;
                }

                $(document).off('submit').on('submit', 'form', function (e) {
                    e.preventDefault();
                    const route = $(this).attr('action');

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {form: JSON.stringify($(this).serializeJSON())},
                        dataType: 'json',
                        success: response => {
                            $("#tableProduct").load(window.location + ' #tableProduct>*', function (response, status, xhr) {
                                $root.plugins();
                            });

                            $('.modal').modal('toggle');
                        }
                    });
                });
            }
        },

        'func_addItem': function (boxSelector, itemName, inputName, itemId) {
            $(document).find(boxSelector).append(`
                    <div data-klient-id="${itemId}"><i class="fa fa-minus-circle btn p-0"></i> ${itemName}
			<input  type="hidden" name="${inputName}" value="${itemId}"/></div>`);
        }
    };
    popup_zenoobrazuvanePrivate.init();

}(window.jQuery, window, document) );

