/* global LANGpop__izborProduct, loadPlugins */
( function ($, window, document, undefined) {

    var popup_econtTovar = popup_econtTovar || {};
    let v = popup_econtTovar;
    let root = popup_econtTovar;
    let valutaSign = '€';

    popup_econtTovar = {
        '__var': {
            //table: '#tbl_packList',
            $modal: $('#' + $('.modal').attr('id'))
        },
        'init': function () {
            v = this.__var;
            root = this;

            this.plugins();
            this.setUpListeners();
        },

        'plugins': function ( ) {
            Cl = curierLocator;
            //Lp = loadPlugins;
            // Lp.popupTitle( );
        },
        'setUpListeners': function () {

            //EVENTS
            v.$modal
                    .on('change', '#ship_date', this.event.change_shipDate)
                    .on('change', '#requestDate', this.event.change_requestDate)
                    .on('change', '#requestHourFrom', this.event.change_requestHourFrom)
                    .on('change', '#sendFrom', this.event.change_sendFrom)
                    .on('change', '#opakovka', this.event.change_opakovka)
                    .on('change', '#isNplatez', this.event.change_nalozenPlatez)
                    .on('change', '#payment', this.event.change_payment)
                    .on('keyup', '.cargoWeight', this.event.change_cargoWeight)
                    .on('input', '#count', this.event.change_count);

            v.$modal.find('#ship_date').trigger('change');

            // BTN
            v.$modal
                    .on('click', '#calculateDostavka', this.btn.calculateDostavka)
                    .on('click', '.econtLocator,#econtLocator', Cl.econtLocator)
                    .on('click', '.speedyLocator,#speedyLocator', Cl.speedyLocator)
                    .on('click', '#save', this.btn.save);
        },

        'event': {
            // при промяна на дата за заявка за куриер
            'change_requestDate': function (e) {
                e.stopImmediatePropagation( );

                $('#requestHourFrom,#requestHourTo').find('option').removeClass('hide');
            },

            // заявка за куриер промяна на 'час от' 
            'change_requestHourFrom': function (e) {
                e.stopImmediatePropagation( );
                const fromVal = parseInt($(this).val());
                const originalOptions = $('#requestHourTo option').clone(); // запазваме всички опции
                $('#requestHourTo').empty(); // изчистваме опциите


                originalOptions.each(function () {
                    const hour = parseInt($(this).val());

                    if (hour >= fromVal) {
                        $('#requestHourTo').append($(this).clone()).find('option').last().prop('selected', true);
                        ;
                    }
                });
            },

            // Доставка нa дата
            'change_shipDate': function (e) {
                e.stopImmediatePropagation( );

                let shipDate = $(this).val();

                if (!shipDate)
                    return;

                let deliverySelect = v.$modal.find("#delivery_date").empty().append('<option value="">Изберете дата</option>');

                getNextValidDates(shipDate).forEach(({ value, text }) =>
                    deliverySelect.append(`<option value="${value}">${text}</option>`)
                );

                function formatDate (dateStr) {
                    let [ yyyy, mm, dd ] = dateStr.split('-');
                    return `${dd}-${mm}-${yyyy}`; // Convert YYYY-MM-DD → DD-MM-YYYY
                }

                function getNextValidDates (startDate) {
                    let dates = [ ], date = new Date(startDate);

                    while (dates.length < 7) {
                        date.setDate(date.getDate() + 1); // Move to next day
                        if (date.getDay() !== 0) { // Exclude Sundays (0 = Sunday)
                            let isoDate = date.toISOString().split('T')[0];
                            dates.push({value: isoDate, text: formatDate(isoDate)});
                        }
                    }
                    return dates;
                }

            },

            // ot къде ще се праща пратката врата или офис
            'change_sendFrom': function (e) {
                e.stopImmediatePropagation( );

                var isDoor = $(this).val() == 'fromDoor';
                var isOffice = $(this).val() == '';

                v.$modal.find('#officeLocatorRow, #block_zaqvkaCurier').toggleClass('hide', !isOffice);
                v.$modal.find('#senderAdresRow').toggleClass('hide', !isDoor);
            },

            // данни за плащане 
            'change_payment': function (e) {
                e.stopImmediatePropagation( );
                var isSmetkaMe = $(this).val() == 'za_smetkaMe';
                var isSmetkaCustom = $(this).val() == 'za_smetkaCustom';

                v.$modal.find('#paymentReceiverRow').toggleClass('hide', !isSmetkaCustom);
                v.$modal.find('#paymentOptionsRow').toggleClass('hide', isSmetkaMe);
            },

            'change_nalozenPlatez': function (e) {
                e.stopImmediatePropagation( );
                var isNp = $(this).is(':checked');

                v.$modal.find('#invoiceBeforePay').prop('disabled', !isNp);
            },

            // промяна на тегло за карго палет
            'change_cargoWeight': function (e) {
                e.stopImmediatePropagation( );
                var sum = 0;
                //var grandWeight = v.$modal.find('#grandWeight').val('1.00');

                v.$modal.find('.razmerPratkaBlock .cargoWeight').each(function () {
                    var _this = $(this);
                    sum += Number(_this.val());
                });
                v.$modal.find('#grandWeight').val(sum);

            },

            'change_count': function (e) {
                e.stopImmediatePropagation( );
                var opakovka = v.$modal.find('#opakovka').val();
                var isPallet = opakovka == 'pallet';
                var clones = $('.razmerPratkaBlock');
                var initialClone = v.$modal.find('.razmerPratkaBlock:first');
                var count = parseInt($(this).val(), 10); // Convert count to integer
                var cloneCount = 0;
                var newClone = '';

                if (count <= 0) {
                    $(this).val(1);
                    return false;
                }

                if (isPallet) {
                    cloneCount = clones.length;

                    if (count > cloneCount) {
                        for (var i = cloneCount; i < count; i++) {
                            newClone = initialClone.clone();
                            newClone.find('input[type="text"], textarea').val('');
                            newClone.insertAfter('.razmerPratkaBlock:last');
                        }
                    }
                    else if (count < cloneCount) {
                        clones.slice(count).remove();
                    }
                }
            },

            'change_opakovka': function (e) {
                e.stopImmediatePropagation( );
                var sendFrom = v.$modal.find('#sendFrom').val();
                var count = v.$modal.find('#count').val(1);
                var grandWeight = v.$modal.find('#grandWeight').val('1.00');
                var isPallet = $(this).val() == 'pallet';
                var isPostPack = $(this).val() == 'post_pack';

                if (isPallet && sendFrom != 'fromDoor') {
                    $(this).val('pack');
                    v.$modal.find('#sizeUnder60').prop('disabled', true);
                    alert('За карго пале изберете Пращане на пратка от врата и адрес на пратката');
                    return false;
                }

                v.$modal.find('#razmerPratkaRow').toggleClass('hide', !isPallet);
                v.$modal.find('#sizeUnder60').prop('disabled', !isPostPack);
            }
        },

        'btn': {
            'calculateDostavka': function (e) {
                e.stopImmediatePropagation();
                var _this = $(this);
                var route = _this.data('route');
                var city = _this.closest('.modal').find('#city_name').val();
                var totalWeight = _this.closest('.modal').find('#grandWeight').val();
                var isOfice = _this.closest('.modal').find('#isOfice').val();
                var opakovka = _this.closest('.modal').find('#opakovka').val();
                var packCount = _this.closest('.modal').find('#count').val();
                var arr = [ ];

                console.log(totalWeight);
                if (totalWeight < 1) {
                    alert('Въведете тегло.');
                    return false;
                }

                arr = {'grad': city, 'packCount': packCount, 'opakovka': opakovka, 'weight': totalWeight, 'isOfice': isOfice};

                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    data: JSON.stringify(arr),
                    success: function (data) {

                        console.log(data);

                        if (data.error) {
                            alert(data.error.message || data.error);
                            return false;
                        }
                        else {
                            _this.parent().find('span').text(data.totalPrice + valutaSign);
                        }
                    }
                });

            },

            'save': function (e) {
                e.stopImmediatePropagation();

                var form = $(this).closest('.modal').find('form');
                var route = form.attr('action');

                if (validate.tovaritelniza_isValid(form) === true) {
                    return false;
                }

                else if (confirm('Сигурни ли сте че искате да генерирате товарителница?') == false) {
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: {'form': form.serializeJSON({checkboxUncheckedValue: '0'})},
                    dataType: 'json',
                    success: function (response) {

                        if (response.error) {
                            alert('Грешка: ' + response.error + '\n\nВъзможни причини кода на офиса не е актуален, за целта обновете данните за доставка за съответния клиент.');
                            return false;
                        }

                        alert('Успешно е създадена товарителница:' + response.label.shipmentNumber);
                        history.go(0);
                    }
                });
                // });
            }
        }
    };

    popup_econtTovar.init();

} )(jQuery, window, document);
