
/* global loadPlugins */
( function ($, window, document, undefined) {

    var printPreview = printPreview || {};
    let v = printPreview;

    var printPreview = {
        '__var': {
            table: '#tbl_products'
        },
        'init': function () {
            v = this.__var;

            Lp = loadPlugins;
            // Lp.table_freezeHeader({'table': v.table, 'margin': 80}); // thead frezze
            this.setUpListeners();
        },
        'setUpListeners': function ( ) {
            // EVENT
            // $(document).on('change', '#nashaFirma', this.events.izbor_nashaFirma);
            // $(document).on('change', '#nashaFirma_bank', this.events.izbor_nashaFirma_bank);
            $(document).on('change', '#izborShablon', this.events.izbor_shablon);

            // BTN
            $(document)
                    .on('click', '#sortProduct_byName', this.btn.sort_productByNAme)
                    .on('click', '#createPdf', this.btn.createPdf)
                    .on('click', '#xls', this.btn.exportXls)
                    .on('click', '#xlsAttr', this.btn.exportXls_attr)
                    .on('click', '.chk', this.btn.checkbox.izborCena)
                    .on('click', '#chk_hideCustomerBlock', this.btn.checkbox.hide_CustomerBlock)
                    .on('click', '.chk_hideCols', this.btn.checkbox.hide_cols)
                    .on('click', '.chk_showKod', this.btn.checkbox.chk_showKod)
                    .on('click', '.chk_showHaracteristika', this.btn.checkbox.chk_showHaracteristika)
                    .on('click', '#chk_inStock', this.btn.checkbox.inStock)
                    .on('click', '#chk_qtyInPDF', this.btn.checkbox.chk_visible_qtyInPDF)
                    .on('click', '#chk_portret, #chk_landscape', this.btn.checkbox.pageOrientation);
        },

        'events': {
            'izbor_shablon': function (e) {
                e.stopImmediatePropagation();

                var route = $(this).data('route');
                var xls = $('.content-header').find('#xls');

                if ($(this).val( ) == '') {
                    $('#printContent').html('');
                    return false;
                }

                $.ajax({
                    type: 'POST',
                    url: route,
                    data: {'shablonId': $(this).val( )},
                    dataType: 'json',

                    success: function (data) {
                        $('#printContent').html(data.view_table);
                        $(document).find('input[type=checkbox]:checked').trigger('click').trigger('click')
                        window.scrollTo(0, 0);
                        Lp.table_freezeHeader('.css-product');
                    }
                });
            }
        },

        'btn': {
            // сортиране по име ASC
            'sort_productByNAme': function (e) {
                e.stopImmediatePropagation();

                let tableBody = $(v.table).find('tbody');

                tableBody.append(
                        tableBody.find('tr').toArray().sort(
                        (a, b) => a.querySelector('.productName').textContent.localeCompare(
                            b.querySelector('.productName').textContent))
                        );
            },

            'checkbox': {
                'chk_visible_qtyInPDF': function (e) {
                    e.stopImmediatePropagation();
                    let isChecked = $(this).is(':checked');
                    let nalichnost = $(v.table).find('tbody td.nalichnost .infoNalichno');

                    nalichnost.toggleClass('show', isChecked);
                },

                'chk_showHaracteristika': function (e) {
                    e.stopImmediatePropagation();

                    let colOpisanie = $(v.table).find('tbody td.opisanie .desk');
                    let colOpisanieAttr = $(v.table).find('tbody td.opisanie .attr');
                    let isChecked = $(this).is(':checked');

                    colOpisanie.toggle(!isChecked);
                    colOpisanieAttr.toggle(isChecked);
                },

                'chk_showKod': function (e) {
                    e.stopImmediatePropagation();

                    let colorRows = $(v.table).find('tbody tr.colorRows td[colspan]');
                    let targetCol = $(v.table).find('.' + this.value);
                    let isChecked = $(this).is(':checked');
                    var colspan = '';

                    targetCol.toggle(isChecked);
                    colspan = $(v.table).find("thead tr:eq(0) th:visible").length;

                    colorRows.attr('colspan', colspan);

                    if ($('input.chk:checked').length >= 1) {
                        $(v.table).attr('style', 'table-layout:auto');
                    }
                },

                'hide_cols': function (e) {
                    e.stopImmediatePropagation();

                    let colorRows = $(v.table).find('tbody tr.colorRows td[colspan]');
                    let targetCol = $(v.table).find('.' + this.value);
                    var colspan = '';

                    targetCol.toggle(!$(this).is(':checked'));

                    if (this.value === 'total' && $(this).is(':checked')) {
                        $(v.table).find("tfoot").hide();
                    }
                    else if (this.value === 'img' && $(this).is(':checked')) {
                        $(v.table).find('tfoot tr th.empty').hide();
                    }
                    else {
                        $(v.table).find("tfoot").show();
                        colspan = $(v.table).find("thead tr:eq(0) th:visible").length;
                        $(v.table).find('tfoot tr th:not(.suma)[colspan]').attr('colspan', colspan - 2);
                    }

                    colspan = $(v.table).find("thead tr:eq(0) th:visible").length;

                    colorRows.attr('colspan', colspan + 1);
                    colorRows.attr('colspan', colspan);

                    // Lp.table_freezeHeader('.css-product'); 
                },

                'hide_CustomerBlock': function (e) {
                    let isChecked = $(this).is(':checked');
                    $(document).find('div.customer_block').toggle(!isChecked);

                    e.stopImmediatePropagation();
                },

                'pageOrientation': function (e) {
                    $('#printArea').toggleClass('css-landscape', this.id === 'chk_landscape');
                    $('#createPdf').attr('data-page-format', $(this).val());

                    e.stopImmediatePropagation();
                },

                'inStock': function (e) {
                    var lang = 'на склад';
                    var isChecked = $(this).is(":checked");
                    var firstSpans = $(v.table).find('tbody td.nalichnost span.first');
                    var secondSpans = $(v.table).find('tbody td.nalichnost span.second');

                    firstSpans.toggle(!isChecked);
                    secondSpans.text(isChecked ? lang : '');

                    e.stopImmediatePropagation();
                },

                'izborCena': function (e) {
                    e.stopImmediatePropagation();

                    const chkInputs = $('input.chk');
                    const table = $(v.table);
                    const colorRows = table.find('tbody tr.colorRows td[colspan]');
                    const chkPortret = $('#chk_portret');
                    const chkLandscape = $('#chk_landscape');
                    const chkShowKod = $('.chk_showKod');


                    chkInputs.not(this).prop("checked", false);

                    if ($(this).is(':checked')) {
                        chkPortret.click();
                    }
                    else if (chkInputs.length > 1) {
                        chkLandscape.click();
                    }

                    chkInputs.each(function () {
                        const _this = $(this);
                        const isChecked = _this.is(':checked');
                        const targetCol = table.find('.' + _this.val());

                        targetCol.toggle(isChecked);
                    });

                    if (chkInputs.is(':checked') === false && chkInputs.length > 1) {
                        table.find('td,th').show();
                        table.removeAttr('style');
                    }

                    if (!chkShowKod.is(':checked')) {
                        table.find('.kod').hide();
                    }

                    const colspan = table.find('thead tr:eq(0) th:visible').length;
                    colorRows.attr('colspan', colspan);

                    //Lp.table_freezeHeader('.css-product');
                }
            },
            'exportXls_attr': function (e) {
                $('.chk_showHaracteristika').trigger('click');
                $('#xls').trigger('click');
            },

            'exportXls': function (e) {
                var route = $(this).data('route');
                var isHaracteristika = $('.chk_showHaracteristika').is(':checked');

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: {'html': $('div#printArea').html( ), 'isHaracteristika': isHaracteristika},
                    dataType: 'json',
                    success: function (data) {
                        var $a = $("<a>", {
                            href: data.file,
                            download: data.fileName
                        });

                        $("body").append($a);
                        $a[0].click();
                        $a.remove();
                    },
                    error: function (xhr, status, error) {
                        console.log(error);
                    }
                });

                e.stopImmediatePropagation();
            },

            // бутон избор на категория
            'createPdf': function (e) {
                e.stopImmediatePropagation();

                var _this = $(this);
                var route = _this.data('route');
                var body = $('div#printArea').html( );
                var pageFormat = _this.attr('data-page-format');
                var shablon = $('#izborShablon').val();
                var chkLength = $('.content-header input.chk:checked').length;
                var oferName = $('.content-header #oferName').text();

                // АКО офертата е поръчка
                if (shablon === '') {
                    alert(LANG__printPreview.alert.shablonEmpty);
                    return false;
                }

                $.ajax({
                    url: route,
                    type: "POST",
                    data: {
                        'body': body,
                        'oferName': oferName,
                        'pageFormat': pageFormat,
                        'chkLength': chkLength,
                        'isZenova': _this.data('iszenova'),
                        'isCatalog': _this.data('isCatalog')
                    },
                    dataType: "binary",
                    xhrFields: {
                        responseType: 'blob'
                    },
                    success: function (response) {

                        var filename = oferName + '.pdf';
                        var blob = new Blob([ response ], {type: 'application/octetstream'});

                        if (typeof window.navigator.msSaveBlob !== 'undefined') {
                            window.navigator.msSaveBlob(blob, filename);
                        }
                        else {
                            var URL = window.URL || window.webkitURL;
                            var downloadUrl = URL.createObjectURL(blob);

                            if (filename) {
                                var a = document.createElement("a");

                                if (typeof a.download === 'undefined') {
                                    window.location = downloadUrl;
                                }
                                else {
                                    a.href = downloadUrl;
                                    a.download = filename;
                                    document.body.appendChild(a);
                                    a.target = "_blank";
                                    a.click();
                                    a.remove();
                                }
                            }
                            else {
                                window.location = downloadUrl;
                            }
                        }
                    },
                    error: function (xhr, status, error) {
                        console.log(error);
                    }
                });
            }
        }
    };
    printPreview.init( );

} )(jQuery, window, document);
