/* global loadPlugins */

( function ($, window, document, undefined) {

    var klient = klient || {};
    let v = klient;

    klient = {
        '__var': {
            table: '#tbl_products',
            tab: 'spisak/Klient'
        },
        'init': function () {
            v = this.__var;
            $.This = this;

            this.plugins();
            this.setUpListeners();
        },
        'plugins': function () {
            Lp = loadPlugins;

            Lp.table_freezeHeader({'table': v.table, 'margin': 75}); // thead frezze
            Lp.columnTableToggle(v.table, v.tab);
            Lp.perPage('#perPage', v.tab);
        },
        'setUpListeners': function ( ) {
            //POPUP
            $(document).on('click', '#new_klient,tbody td.action .edit', this.modal.open_popup_klient);

            //EVENTS
            $(document)
                    .on('keyup', 'thead .filter', this.events.filter)
                    .on('change', 'tbody .zenaNivo ', this.events.change_zenaNivo)
                    .on('change', 'thead #select-all', this.events.select_allKlients);


            //BTN
            $(document)
                    .on('click', 'table thead .sort', this.btn.colSort)
                    .on('click', '#priceLevelToAll', this.btn.priceLevelToAll);
        },

        'modal': {
            'open_popup_klient': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            }
        },

        'events': {
            'select_allKlients': function (e) {
                e.stopImmediatePropagation();

                let _this = $(this);
                let table = _this.closest('table');

                table.find("tbody input[type=checkbox]").prop('checked', $(this).is(':checked'));
            },

            'change_zenaNivo': function (e) {
                e.stopImmediatePropagation();

                var _this = $(this);
                var route = _this.data('route');
                var klientId = _this.closest('tr').attr('data-id');
                var firmaText = _this.closest('tr').find('td.firma').text();
                var previousValue = _this.parent().find('option[selected]').val();
                var newValue = _this.val();

                if (confirm(`Искате ли да промените ценовото ниво за клиент - ${firmaText}?`)) {
                    $.ajax({
                        url: route,
                        type: "POST",
                        data: {'klientIds': klientId, 'selectedPriceLevel': newValue},
                        success: function (data)
                        {

                        }
                    });
                }
                else {
                    $(this).val(previousValue);
                }
            },

            //търсене по име и колона
            'filter': function (e) {
                var _this = $(this);
                var col = _this.data('sqlCol');
                var params = new URLSearchParams(window.location.search);

                if (e.key !== "Enter" && _this.val( )) {
                    return false;
                }

                if (_this.val( ).indexOf(' ') >= 0) {
                    _this.val(_this.val( ).trim( ));
                }

                params.set('page', 1);
                params.set('col', col);
                params.set('searchName', _this.val( ));
                history.replaceState({}, '', '?' + params.toString( ));

                if (_this.val( ).length == 0) {
                    params.delete('searchName');
                    params.delete('col');
                    history.replaceState({}, '', '?' + params.toString( ));
                    history.go(0);
                    return false;
                }

                history.go(0);
            }
        },

        'btn': {
            'priceLevelToAll': function (e) {
                var priceLevelList = $('#priceLevelList');
                var checkedInputs = $(v.table).find("input:checked").map(function () {
                    return this.value;
                }).get();

                if (priceLevelList.val() === '') {
                    alert('Изберете ценово ниво');
                }
                else if (checkedInputs.length === 0) {
                    alert('Маркирайте желаниете клиенти на които искате да смените ценовото ниво.');
                }
                else if (confirm('Сигурнили сте че искате да промените ценовото ниво на избраните клиенти?')) {
                    $.ajax({
                        url: $(this).data('route'),
                        type: 'POST',
                        data: {'klientIds': checkedInputs, 'selectedPriceLevel': priceLevelList.val()},
                        dataType: 'json',
                        success: function (response) {
                            history.go(0);
                        }
                    });
                }
                else {
                    priceLevelList.val('');
                    $(v.table).find("input:checked").prop('checked', false);
                }
            },

            'colSort': function (e) {

                var rowIndex = $(this).closest('th').index();
                var col = $(this).closest('thead').find('tr:eq(1)').find('th:eq(' + rowIndex + ') input').data('sqlCol');
                var sort = $(this).data('sqlSort');

                var params = new URLSearchParams(window.location.search);
                params.set('sort_col', col);
                params.set('sort_order', sort);
                history.replaceState({}, '', '?' + params.toString());

                history.go(0);
            }
        }
    };

    klient.init( );

} )(jQuery, window, document);

