/* global loadPlugins */

( function ($, window, document, undefined) {

    var produkt = produkt || {};
    let v = produkt;

    produkt = {
        '__var': {
            tab: 'spisak/Product',
            table: '#tbl_products'
        },
        'init': function ( ) {
            v = this.__var;
            $.This = this;
            $root = this;

            this.plugins( );
            this.setUpListeners( );
        },
        'plugins': function ( ) {
            Lp = loadPlugins;

            Lp.popupTitle();
            Lp.zoomImg();
            Lp.table_freezeHeader({'table': v.table, 'margin': 80}); // thead frezze
            Lp.columnTableToggle(v.table, v.tab);
            Lp.perPage('#perPage', v.tab);
        },
        'setUpListeners': function ( ) {

            // POPUP 
            $(document).on('click', 'tbody .edit_product, #new_product', this.modal.open_popup_editProduct);

            //EVENTS
            $(document)
                    .on('keyup', 'thead .filter', this.events.filter)
                    .on('change', 'thead #category', this.events.filter_by_category);

            //BTN
            $(document)
                    .on('click', '#selectAll_product', this.btn.selectAll_product)
                    .on('click', '#oneCatToManyProduct', this.btn.oneCatToManyProduct)
                    .on('click', '#saveNalich', this.btn.saveNalich)
                    .on('click', 'table thead .sort', this.btn.colSort)
                    .on('click', 'tbody .toSite', this.btn.toSite)
                    .on('click', 'tbody td.action .cloneProduct', this.btn.cloneProduct);
        },
        'modal': {
            'open_popup_editProduct': function ( ) {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET', 'ckeditor': true});
            }
        },

        'events': {
            //търсене по категория
            'filter_by_category': function ( ) {
                var _this = $(this);

                if (_this.val( ).indexOf(' ') >= 0) {
                    _this.val(_this.val( ).trim( ));
                }

                var params = new URLSearchParams(window.location.search);

                params.set('page', 1);
                params.set('categoryId', _this.val( ));
                history.replaceState({}, '', '?' + params.toString( ));

                if (_this.val( ).length == 0) {
                    params.delete('categoryId');
                    history.replaceState({}, '', '?' + params.toString( ));
                    history.go(0);
                    return false;
                }

                history.go(0);
            },

            //търсене по име и колона
            'filter': function (e) {
                var _this = $(this);
                var col = _this.data('sqlCol');
                var params = new URLSearchParams(window.location.search);

                if (e.key !== "Enter" && _this.val( )) {
                    return false;
                }

                if (_this.val( ).indexOf(' ') >= 0) {
                    _this.val(_this.val( ).trim( ));
                }

                params.set('page', 1);
                params.set('col', col);
                params.set('searchName', _this.val( ));
                history.replaceState({}, '', '?' + params.toString( ));

                if (_this.val( ).length == 0) {
                    params.delete('searchName');
                    params.delete('col');
                    history.replaceState({}, '', '?' + params.toString( ));
                    history.go(0);
                    return false;
                }

                history.go(0);
            }
        },
        'btn': {
            // маркиране на всички продукти
            'selectAll_product': function (e) {
                $(v.table).find("tbody input.chk_productId").prop('checked', $(this).is(':checked'));
            },

            // маркиране на продукт към всички сайтове за конкретната ценова листа
            'toSite': function (e) {
                var _this = $(this);
                var productName = _this.closest('tr').find('td.productName').text();
                var route = $(this).data('route');
                var hasKKC = $(this).data('cenakkc');
                var hasrootcat = $(this).data('hasrootcat');
                var is_toSite = _this.is(':checked') ? 1 : 0; // 0-false 1-true
                var actionText = is_toSite ? 'добавите в' : 'премахнете от';

                if ($(this).data('notPrice') !== undefined || ! hasKKC) {
                    alert('Продукта не е ценообразуван и неможе да се добави към сайт.');
                    return false;
                }
                else if (! hasrootcat) {
                    alert('Липсва категория на продукта и неможе да бъде избран!');
                    return false;
                }

                if (! confirm(`Сигурни ли сте, че искате да ${actionText} всички сайтове продукта \n\n ${productName}`)) {
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: {'is_toSite': is_toSite},
                    dataType: 'json',
                    success: function (response) {
                        if (response.err) {
                            _this.prop('checked', false);
                            alert(response.err);
                        }

                        else if (response.success) {
                            alert(response.success);
                        }
                    }
                });
            },
            // обновяване на наличността на продукти
            'saveNalich': function (e) {
                var value = $('#nalich_for_update');
                let checkedInputs = $(v.table).find("input.chk_productId:checked").map(function () {
                    return this.value;
                }).get();
                let isChecked = checkedInputs.length === 0 ? 'всички продукти' : 'избраните продукти';
                if (value.val() === '') {
                    alert('Въведете наличност.');
                    return false;
                }

                if (! confirm(`Тази операция ще обнови наличността на ${isChecked}!\n\n Сигурнили сте че искате да продължите?`)) {
                    return false;
                }

                $.ajax({
                    url: $(this).data('route'),
                    type: 'POST',
                    data: {'productIds': checkedInputs, 'value': value.val()},
                    dataType: 'json',
                    success: function (response) {
                        history.go(0);
                    }
                });
            },

            // 1 категория за много маркирани продукти
            'oneCatToManyProduct': function (e) {
                var categoryList = $('#categoryList');
                var checkedInputs = $(v.table).find("input.chk_productId:checked").map(function () {
                    return this.value;
                }).get();

                if (categoryList.val() === '') {
                    alert('Изберете категория');
                }
                else if (checkedInputs.length === 0) {
                    alert('Маркирайте желаниете продукти на които искате да смените категориятя.');
                }
                else if (confirm('Сигурнили сте че искате да промените категорията на избраните продукти?')) {
                    $.ajax({
                        url: $(this).data('route'),
                        type: 'POST',
                        data: {'productIds': checkedInputs, 'selectedCategoryId': categoryList.val()},
                        dataType: 'json',
                        success: function (response) {
                            history.go(0);
                        }
                    });
                }
                else {
                    categoryList.val('');
                    $(v.table).find("input:checked").prop('checked', false);
                }
            },

            'cloneProduct': function (e) {

                var _this = $(this);
                var route = _this.data('route');

                var newProductName = prompt('Въведете ново име', '');

                if (newProductName == '') {
                    alert('Въведете име за продукт!');
                    return false;
                }

                if (! newProductName) {
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: {'newProductName': newProductName},
                    dataType: 'json',
                    success: function (response) {
                        if (response.dub === true) {
                            alert(response.data);
                            return false;
                        }
                        else {
                            history.go(0);
                        }
                    }
                });

                e.stopImmediatePropagation();
            },

            'colSort': function (e) {

                var sql = $(this).data('sql');
                var params = new URLSearchParams(window.location.search);

                params.set('sort_col', sql.col);
                params.set('sort_order', sql.sort);
                history.replaceState({}, '', '?' + params.toString( ));
                history.go(0);
            }
        }
    };
    produkt.init( );

} )(jQuery, window, document);

