/**
 * @license Copyright © 2013 Stuart Sillitoe <stuart@vericode.co.uk>
 * This work is mine, and yours. You can modify it as you wish.
 *
 * Stuart Sillitoe
 * stuartsillitoe.co.uk
 *
 */


CKEDITOR.plugins.add('strinsert',
{
    requires: [ 'richcombo' ],
    init: function (editor)
    {
        var config = editor.config;

        //  array of strings to choose from that'll be inserted into the editor
        var strings = [ ];
        strings = editor.config.strinsert_strings;


        //	strings.push(['@@CareerCourse::displayList()@@', 'Career Courses', 'Career Courses']);
        //strings.push(['@@CareerProfile::displayList()@@', 'Career Profiles', 'Career Profiles']);

        // add the menu to the editor
        editor.ui.addRichCombo('strinsert',
        {
            label: config.strinsert_button_label,
            title: config.strinsert_button_title,
            voiceLabel: config.strinsert_button_voice,
            className: 'cke_format',
            multiSelect: false,
            panel:
            {
                css: [ editor.config.contentsCss, CKEDITOR.skin.getPath('editor') ],
                voiceLabel: editor.lang.panelVoiceLabel
            },

            init: function ()
            {
                //this.startGroup( "Insert Content" );
                var flag = false;
                for (var i in strings)
                {
                    this.add('<b class="text-danger">'+strings[i].value+'</b>', strings[i].name);
                }
            },

            onClick: function (value)
            {
                editor.focus();
                editor.fire('saveSnapshot');
                editor.insertHtml(value);
                editor.fire('saveSnapshot');
            }
        });
    }
});
