/*
 |---------------------------------------------------------------
 | === PLUGIN за промяна на image път в базата данни ============
 |------------------------------------------------------------- */

CKFinder.define(function () {

    let self = imageModificate;

    var imageModificate = {
        oldFolderPatch: null,
        oldFolderName: null,

        init: function (finder) {
            self = this;

            const folderNames = [ '_models', '_brand' ];
            ;
            const resourceType = 'productImages';
            const currentFolder = '/';
            const hash = 'be341a03c190a788'; // TODO: вземи динамично
            const ckCsrfToken = 'aXW7eNhNX4D3AJ1OV2Y1dovtpi5rgAEdfVJson0X'; // TODO: вземи динамично

            /**
             * Създава папка, ако липсва
             */
            function createFolderIfMissing () {
                // 1. Проверка дали папката вече съществува
                $.get('/assets/plugins/ckfinder/core/connector/php/connector.php', {
                    command: 'GetFolders',
                    type: resourceType,
                    currentFolder: currentFolder,
                    hash: hash,
                    lang: 'bg'
                }, function (res) {
                    if (!res || !res.folders)
                        return;

                    const existingNames = res.folders.map(f => f.name);

                    folderNames.forEach(folderName => {
                        if (existingNames.includes(folderName)) {
                            console.log(`📁 Папката "${folderName}" вече съществува`);
                            return;
                        }

                        // 2. Създаване на нова папка
                        $.ajax({
                            url: '/assets/plugins/ckfinder/core/connector/php/connector.php' +
                                    '?command=CreateFolder' +
                                    '&lang=bg' +
                                    '&langCode=bg' +
                                    '&type=' + resourceType +
                                    '&currentFolder=' + encodeURIComponent(currentFolder) +
                                    '&hash=' + hash +
                                    '&newFolderName=' + encodeURIComponent(folderName),
                            type: 'POST',
                            dataType: 'json',
                            headers: {'X-Requested-With': 'XMLHttpRequest'},
                            data: {ckCsrfToken: ckCsrfToken},
                            success: function (res) {
                                if (res && res.errorNumber === 0) {
                                    console.log(`✅ Папката ${folderName} е създадена успешно`);
                                }
                                else if (res && res.errorNumber === 103) {
                                    console.log(`📁 Папката ${folderName} вече съществува`);
                                }
                                else {
                                    console.warn('⛔ Грешка при създаване:', res);
                                }
                            },
                            error: function (xhr) {
                                console.error('❌ AJAX грешка:', xhr.responseText);
                            }
                        });
                    });
                }, 'json');
            }

            // Стартирай при зареждане
            createFolderIfMissing();



            // Rename file
            // =========================
            finder.on('command:before:RenameFile', function (evt) {
                evt.data.params.newFileName = sanitizeName(evt.data.params.newFileName);
            });

            finder.on('command:after:RenameFile', function (evt) {
                let  {name, newName, currentFolder, resourceType} = evt.data.response;
                let currentDir = evt.finder.config.id;
                let folderPath = currentFolder.path.replace(/^\//, '');
                var arrData = {};

                console.log(evt);
                name = folderPath + name;
                newName = folderPath + newName;

                arrData = {'command': 'renameFile', 'resourceType': resourceType, 'currentDir': currentDir, 'name': name, 'newName': newName};

                ajax_send(arrData);
            });

            // Delete files
            // =========================
            finder.on('command:before:DeleteFiles', function (evt) {
                var attributes = evt.data.folder.attributes;
                var currentDir = evt.finder.config.id;
                var resourceType = attributes.resourceType;
                var arr_deletingFiles = evt.data.post.files;
                var arrData = {'command': 'deleteFiles', 'currentDir': currentDir, 'resourceType': resourceType, 'arr_deletingFiles': arr_deletingFiles};

                ajax_send(arrData);
            });

            // Move files
            // ==========================
            finder.on('command:before:MoveFiles', function (evt) {
                this.oldFolderPatch = evt.data.post.files;
                this.oldFolderName = evt.data.post.files[0].folder.replace(/^\//, '');
            });

            finder.on('command:after:MoveFiles', function (evt) {
                let currentDir = evt.finder.config.id;
                let new_FolderPatch = evt.data.response.currentFolder.path.replace(/^\//, '');

                var arrData = {'command': 'moveFiles', 'currentDir': currentDir, 'arr_old_FolderPatch': this.oldFolderPatch, 'new_FolderPatch': new_FolderPatch, 'old_FolderName': this.oldFolderName};
                console.log(evt);
                ajax_send(arrData);
            });

            // Create folder
            // =========================
            finder.on('command:before:CreateFolder', function (evt) {
                const clean = sanitizeName(evt.data.params.newFolderName);
                evt.data.params.newFolderName = clean;
                evt.data.context.newFolderName = clean;
            });

            // Rename folder
            // =========================
            finder.on('command:before:RenameFolder', function (evt) {

                var currentFolder = evt.data.context.folder.attributes.name;
                const clean = sanitizeName(evt.data.params.newFolderName);
                const denied = [ 'categories', '_models', '_brand' ];

                if (denied.some(prefix => currentFolder.startsWith(prefix))) {
                    alert(`Не може да редактирате името на папка ${currentFolder}.`);
                    evt.cancel();

                    // Затваряш ръчно командата → спинерът спира
                    finder.fire('command:after:RenameFolder', {response: {status: 1, error: {}}});
                }

                evt.data.params.newFolderName = clean;
                evt.data.context.newFolderName = clean;
                console.log(evt);
            });

            finder.on('command:after:RenameFolder', function (evt) {
                let {newPath, currentFolder} = evt.data.response;
                if (!newPath)
                    return;
                let currentDir = evt.finder.config.id;
                let newFolderName = newPath.replace(/^\//, '');
                let currentFolderName = currentFolder.path.replace(/^\//, '');

                var arrData = {'command': 'renameFolder', 'currentDir': currentDir, 'currentFolderName': currentFolderName, 'newFolderName': newFolderName};
                console.log(evt);
                ajax_send(arrData);
            });

            finder.on('command:before:DeleteFolder', function (evt) {
                let currentFolderName = evt.data.context.folder.attributes.name;
                const denied = [ 'categories', '_models', '_brand' ];

                if (denied.some(prefix => currentFolderName.startsWith(prefix))) {
                    alert(`Не може да изтривате папката ${currentFolderName}.`);
                    evt.cancel();

                    // Затваряш ръчно командата → спинерът спира
                    finder.fire('command:after:RenameFolder', {response: {status: 1, error: {}}});
                }
                var arrData = {'command': 'deleteFolder', 'currentDir': evt.finder.config.id, 'currentFolderName': currentFolderName};

                ajax_send(arrData);
            });
        }
    };

    function sanitizeName (name = '' ) {
        const cyrillicToLatinMap = {
            'а': 'a', 'б': 'b', 'в': 'v', 'г': 'g', 'д': 'd',
            'е': 'e', 'ж': 'zh', 'з': 'z', 'и': 'i', 'й': 'y',
            'к': 'k', 'л': 'l', 'м': 'm', 'н': 'n', 'о': 'o',
            'п': 'p', 'р': 'r', 'с': 's', 'т': 't', 'у': 'u',
            'ф': 'f', 'х': 'h', 'ц': 'ts', 'ч': 'ch', 'ш': 'sh',
            'щ': 'sht', 'ъ': 'a', 'ь': '', 'ю': 'yu', 'я': 'ya',

            'А': 'A', 'Б': 'B', 'В': 'V', 'Г': 'G', 'Д': 'D',
            'Е': 'E', 'Ж': 'Zh', 'З': 'Z', 'И': 'I', 'Й': 'Y',
            'К': 'K', 'Л': 'L', 'М': 'M', 'Н': 'N', 'О': 'O',
            'П': 'P', 'Р': 'R', 'С': 'S', 'Т': 'T', 'У': 'U',
            'Ф': 'F', 'Х': 'H', 'Ц': 'Ts', 'Ч': 'Ch', 'Ш': 'Sh',
            'Щ': 'Sht', 'Ъ': 'A', 'Ь': '', 'Ю': 'Yu', 'Я': 'Ya'
        };

        const transliterated = name.replace(/[а-яА-Я]/g, char => cyrillicToLatinMap[char] || char);
        return transliterated.trim()
                .replace(/\s+/g, '_')   // замени интервали с _
                .replace(/_+/g, '_')    // премахни излишни _
        //.replace(/[^\w\-]/g, ''); // премахни символи, които не са букви, цифри или _
    }

    function ajax_send (arr) {

        $.ajax({
            url: '/MyPlugin',
            type: "POST",
            dataType: 'json',
            data: arr,
            success: function (data) {
                if (data.status == 'failed') {
                    alert('Грешка: данните за снимките в базата данни не са обновени!');
                }
            }
        });
    }

    return imageModificate;
});



