( function ($) {

    $.fn.clearinput = function (opts) {

        var defaults = {
            'iconClass': 'clearinput',
            'focusOnClear': true,
            'iconText': '&times;'
        };

        var settings = $.extend(defaults, opts);

        var init = function () {

            var $this = $(this),
                    $icon,
                    wrapperClass = settings.iconClass + '-wrapper d-inline w-100',
                    clearField,
                    checkField,
                    hasText,
                    update;

            if (!$this.parent().hasClass(wrapperClass)) {

//                var wrapParts = [
//                    // '<div style="position: relative;" class="' + wrapperClass + '">',
//                    $this.html(),
//                            // '</div>'
//                ];
//                
                $this.wrap('<div class="' + wrapperClass + '" style="position:relative;"></div>');

                //$this.wrap(wrapParts.join(''));
                var inp = $this.parent().hasClass('input-group-prepend');

                var afterParts = [
                    '<a style="position:' + ( inp ? 'relative' : 'absolute' ) + '; cursor: pointer;" class="' + settings.iconClass + '">',
                    settings.iconText,
                    '</a>'
                ];

                $this.after(afterParts.join(''));
            }

            $icon = $this.next();

            clearField = function () {
                $this.val('').trigger('keyup').trigger('input');
                checkField();

                if (settings.focusOnClear) {
                    $this.focus();
                }
                if (typeof ( settings.callback ) === 'function') {
                    settings.callback();
                }
            };

            checkField = function () {

                if (hasText() && $this.is(':focus')) {
                    $icon.show();
                }

                else {
                    $icon.hide();
                }

                update();
            };

            hasText = function () {
                return $this.val().replace(/^\s+|\s+$/g, '').length > 0;
            };

            update = function () {
                var width = $this.outerWidth(), height = $this.outerHeight();
                var inp = $this.parent().hasClass('input-group-prepend');

                $icon.css({
                    'margin-left': '-13px',
                    'color': '#dc3545 !important',
                    'z-index': 1,
                    //'background': '#fff',
                    //'border': '1px solid #d4d0d0',

                    'padding': '3px'
                            // top: height / 2 - $icon.height() / 1.5,
                            //left: width - height / 2 - $icon.height() / 2
                });
            };

            $icon.on('mousedown', clearField);

            $this.on('keyup keydown change focus blur', checkField);
            $(window).on('resize', update);

            checkField();

        };

        return this.each(init);

    };
} )(jQuery);
