/**
 * Validation wrapper.
 *
 * @author Htmlstream
 * @version 1.0
 * @requires
 *
 */
var isEmpty = function isEmpty (f) {
    return ( /^function[^{]+\{\s*\}/m.test(f.toString())
            );
}


;
( function ($) {
    'use strict';

    $.HSValidation = {
        /**
         *
         *
         * @var Object _baseConfig
         */
        _baseConfig: {
            errorElement: 'div',
            errorClass: 'invalid-feedback',
            rules: {
                tel: {
                    required: true,
                    maxlength: 14,
                    number: true,
                    minlength: 6,
                    normalizer: function (value) {
                        return value.replace(/\s+/g, ''); // Removes all spaces
                    }
                }
            },
            messages: {
                tel: {
                    required: "Моля, въведете телефонен номер.",
                    minlength: "Телефонният номер трябва да бъде най-малко 6 цифри.",
                    maxlength: "Телефонният номер не може да надвишава 14 цифри.",
                    number: "Моля, въведете валиден телефонен номер (само цифри)."
                }
            },
            onkeyup: function (element) {
                $(element).valid()
            },
            errorPlacement: function () {},
            highlight: function () {},
            unhighlight: function () {},
            submitHandler: function () {}
        },

        /**
         *
         *
         * @var jQuery pageCollection
         */
        pageCollection: $(),

        /**
         * Initialization of Validation wrapper.
         *
         * @param String selector (optional)
         * @param Object config (optional)
         *
         * @return jQuery pageCollection - collection of initialized items.
         */

        init: function (selector, config) {
            this.collection = selector && $(selector).length ? $(selector) : $();
            if (!$(selector).length)
                return;


            this.config = config && $.isPlainObject(config) ?
                    $.extend({}, this._baseConfig, config) : this._baseConfig;

            $.extend(this.config.rules, this._baseConfig.rules);

            this.config.itemSelector = selector;

            this.initValidation();

            return this.pageCollection;
        },

        initValidation: function () {
            //Variables
            var $self = this,
                    config = $self.config,
                    collection = $self.pageCollection;

            //Actions
             $('.alert').remove()
            this.collection.each(function (i, el) {
                //Variables
                var $this = $(el);

                if ($this.hasClass('js-step-form')) {
                    $.validator.setDefaults({
                        ignore: ':hidden:not(.active select)'
                    });
                }
                else {
                    $.validator.setDefaults({
                        ignore: ':hidden:not(select)'
                    });
                }

                $this.validate({
                    errorElement: config['errorElement'],
                    errorClass: config['errorClass'],
                    rules: config['rules'],
                    messages: config['messages'],
                    onkeyup: config['onkeyup'],
                    errorPlacement: isEmpty(config['errorPlacement']) === true ? $self.errorPlacement : config['errorPlacement'],
                    highlight: isEmpty(config['highlight']) === true ? $self.highlight : config['highlight'],
                    unhighlight: isEmpty(config['unhighlight']) === true ? $self.unHighlight : config['unhighlight'],
                    submitHandler: isEmpty(config['submitHandler']) === true ? $self.submitHandler : config['submitHandler']
                });
        
                if ($this.find('select').length) {

                    $('select').change(function () {
                        $(this).valid();
                    });

                }


                //Actions
                collection = collection.add($this);
            });
        },

        errorPlacement: function (error, element) {
            var $this = $(element),
                    errorMsgClasses = $this.data('error-msg-classes');
            let txt = 'Попълнете задължителните полета';

            error.addClass(errorMsgClasses);

            let errorMessages = error.map(function ( ) {
                return `<div>${$(this).text().trim( )}</div>`;
            }).get( ).join('');


let errorContainer = $('.alert');

if (errorContainer.length) {
    // Ако контейнерът съществува, добавяме новите съобщения към него
    $(errorMessages).appendTo(errorContainer);
} else {
    // Ако контейнерът не съществува, създаваме нов и го добавяме към body
    $('body').append(`<div class="alert alert-danger alert-dismissible fade show" role="alert">${txt}</div>`);
}


//            let errorBlock = `<div class="alert alert-danger alert-dismissible fade show" role="alert">
//    <fieldset class="p-2 pt-3"><strong class="fa fa-exclamation-triangle"></strong> ${txt}${errorMessages}</fieldset>
//    <button type="button" class="close p-1" data-dismiss="alert" aria-label="Close">
//      <span>&times;</span>
//    </button>
//  </div>`;



            //console.log(errorBlock);
            //$('.alert').remove();
           // $('body').append(errorBlock);



        },

        highlight: function (element) {
            var $this = $(element),
                    errorClass = $this.data('error-class'),
                    successClass = $this.data('success-class');

            var danger = 'bg-danger css-animation-err'

            $(element).removeClass(danger).addClass(danger);

            $this.parents('.js-form-message').removeClass(successClass).addClass(errorClass);
            // console.log($('form').find('.' + errorClass + ':visible').length);

        },

        unHighlight: function (element) {
            var $this = $(element),
                    errorClass = $this.data('error-class'),
                    successClass = $this.data('success-class');
            var danger = 'bg-danger css-animation-err';

            $this.parents('.js-form-message').removeClass(errorClass).addClass(successClass);
            
            if ($('form').find('.' + errorClass + ':visible').length > 0) {
                $('.alert').remove();
                $(element).removeClass(danger);
            }
            
        },

        submitHandler: function (form) {
            console.log(234);
            return form;
            //form.submit();
        }
    };
} )(jQuery);
