;
( function ($) {
    $.fn.multifilter = function (options) {
        var settings = $.extend({
            'target': $('table'),
            'method': 'thead' // This can be thead or class
        }, options);

        jQuery.expr[":"].Contains = function (a, i, m) {
            return ( a.textContent || a.innerText || "" ).toUpperCase().indexOf(m[3].toUpperCase()) >= 0;
        };

        function debounce (func, wait) {
            let timeout;
            return function () {
                const context = this, args = arguments;
                clearTimeout(timeout);
                timeout = setTimeout(() => func.apply(context, args), wait);
            };
        }

        this.each(function () {

            var $this = $(this);
            var container = $this.closest('.table');
            var row_tag = 'tbody tr';
            // console.log(container.find($($this))[0].offsetParent.className);return false;
            var item_tag = '.productName';
            var rows = container.find($(row_tag));



            if (container.find($($this))[0].offsetParent) {
                //item_tag = container.find($($this))[0].offsetParent.className;
            }

            if (settings.method === 'thead') {
                // Match the data-col attribute to the text in the thead
                var col = container.find('th:Contains(' + $this.data('col') + ')');
                var col_index = container.find($('thead th:visible')).index(col);

            }
            ;

            if (settings.method === 'class') {
                // Match the data-col attribute to the class on each column
                var col = rows.first().find('td.' + $this.data('col') + '');
                var col_index = rows.first().find('td').index(col);
            }
            ;

            $this.change(function () {

                var filter = $this.val() || this.value;
                var colspan = container.find('thead tr:eq(0) th:visible').length;
                var rows = container.find($(row_tag));

                rows.each(function () {

                    var row = $(this);
                    var cell = $(row.children(item_tag));

                    if (filter) {
                        container.find('tbody tr.colorRows').hide();

                        // Аксесоар Моб.Тел. Калъф Remax Nora Rose IPhone7 
                        if (cell.text().toLowerCase().trim().indexOf(filter.toLowerCase().trim()) !== -1) {
                            row.attr('data-filtered', 'positive');
                        }
                        else {
                            row.attr('data-filtered', 'negative');
                        }

                        if (row.attr('data-filtered') === 'negative') {
                            row.hide();
                        }
                        else {
                            if (row.attr('data-filtered') === 'positive') {
                                row.show();
                            }
                        }
                    }
                    else {
                        row.attr('data-filtered', 'positive');
                        row.show();
                        // Lp.lazyLoadTable(); 
                    }
                });

                if (container.find('tbody tr:visible').length == 0 && container.find('tbody tr.emptyRow:visible').length == 0) {

                    container.find('tbody').append('<tr class="emptyRow"><td class="text-red" colspan="' + colspan + '">Няма намерени резултати от търсенето</td></tr>');
                }

                else if (container.find('tbody tr:not(.emptyRow):visible').not('.emptyRow').length != 0) {
                    container.find('tbody tr.emptyRow').remove();
                }

                return false;

            }).keyup(debounce(function () {
                $this.change();
                $('html, body').scrollTop(0);
            }, 1000));

            // keyup в кполето филтър
            // =======================
//            container.find('thead').on('keyup', 'input[type=search]', function (e)
//            {
//                var visible = Boolean($(this).val( ));
//                // показване на х за нулиране
//                $(this).parent().find('span').toggleClass('hide', !visible);
//            });
//
//            container.find('thead').on('click', '.clearFilter', function ( ) {
//                $(this).toggleClass('hide');
//                $(this).parent().find('input[type=search]').val('').trigger('keyup');
//            });

        });
    };

} )(jQuery);
