( function ($, window, document, undefined) {
    "use strict";

    $.fn.PageLength = function (options) {

        // Default options
        var defaults = {
            key: '',
            perPage: ''
        };

        var options = $.extend(defaults, options);

        this.init = function () {
            var $this = $(this),
                    $selectOptions = $('option', this);
            //listItems = {};

            if (options.key.length > 0) {
                var listPageIndex = sessionStorage.getItem(options.keyPrefix + options.key);

                if (listPageIndex !== null && listPageIndex.length > 0) {

                    $($selectOptions).removeAttr('selected');

                    $selectOptions.each(function (index, el) {
                        if ($(el).val() == listPageIndex) {
                            $(el).attr('selected', 'selected');
                            return false;
                        }
                    });
                }
            }

            $(document).on('change', 'select[id="' + $this.attr('id') + '"]', function () {
                var value = $this.val();

                $.ajax({
                    url: $(this).data('route')+'&perPage='+value,
                    type: 'POST',
                    dataType: 'json',
                    //data: {'perPage': value},
                    success: function (data) {
                        history.replaceState({}, '', window.location.search.replace(/&perPage=.*/g, '') + '&perPage=' + value);
                        location.reload();
                    }
                });
            });
        };

        return this.init();

    };
}(jQuery, window, document) );
