<?php

ini_set('display_errors', '1');
require_once __DIR__ . '/../app/Config/Paths.php';

$paths = new Config\Paths();
require_once $paths -> systemDirectory . '/bootstrap.php';
require_once SYSTEMPATH . 'ThirdParty/Kint/init.php';
//require_once SYSTEMPATH . 'Config/DotEnv.php';
// Зареждаме .env
//require_once SYSTEMPATH . 'Config/DotEnv.php';
//(new DotEnv(ROOTPATH)) -> load();

(new CodeIgniter\Config\DotEnv(ROOTPATH)) -> load();
// Дефинираме среда
defined('ENVIRONMENT') || define('ENVIRONMENT', 'production');

// Kint режими
Kint::$expanded = true;

// Ако dd() не съществува – създаваме го
if (!function_exists('dd')) {

    function dd(...$vars) {
        foreach ($vars as $v) {
            Kint::dump($v);
        }
        die(1);
    }

}

use CodeIgniter\Controller;
use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use Config\Paths;
use CodeIgniter\Config\DotEnv;
use \App\Models\BaseModel;

abstract class BaseCron {

    // Максимално време за работа на един cron цикъл (в секунди)
    // бр. итерации(колко пъти да се стартира)
    protected int $maxRuntime = 60;
    // Пауза между итерациите (в секунди)
    protected int $delay      = 10;
    // Максимално допустима възраст на lock файла (stale lock защита)
    protected int $staleLock  = 120;

    public function __construct() {
        
    }

    final public function run($jobName, $debug = false) {
        $db = db_connect();

        $this -> prepareEnvironment();

        //$this -> BaseModel = new BaseModel();

        /* 1. Вземаме задачата */
        $jobRow = $db -> table(BaseModel::TBL_CRONJOBS)
                        -> where('job_key', $jobName)
                        -> get() -> getRow();

        if (!$debug && (!$jobRow || (int) $jobRow -> is_enabled !== 1)) {
            CLI::write("Cron клас - {$jobName} е деактивиран", 'red');
            return;
        }

        /* ===== START STATUS ===== */
        $db -> table(BaseModel::TBL_CRONJOBS)
                -> where('job_key', $jobName)
                -> update([
                    'is_running'  => 1,
                    'last_run'    => date('Y-m-d H:i:s'),
                    'last_status' => 'RUNNING'
        ]);

        // Файл за заключване (lock), за да не се застъпят два cron процеса
        $lock = WRITEPATH . $jobName . '.lock';
        $pid  = getmypid();

        if (file_exists($lock)) {
            // Изчисляваме колко време съществува lock-ът
            $age = time() - filemtime($lock);

            // Ако lock-ът е твърде стар – премахваме lock-ът
            if ($age > $this -> staleLock) {
                unlink($lock);
                CLI::write("Stale lock removed ({$age}s)", 'yellow');
            } else {
                CLI::write("Already running (PID: " . trim(file_get_contents($lock)) . ", {$age}s)", 'red');
                return;
            }
        }

        file_put_contents($lock, $pid);

        CLI::write("CRON START " . date('H:i:s'), 'green');

        try {
            // Основен работен цикъл 
            $this -> runLoop();

            /* ===== SUCCESS END ===== */
            $db -> table(BaseModel::TBL_CRONJOBS)
                    -> where('job_key', $jobName)
                    -> update([
                        'is_running'  => 0,
                        'last_status' => 'OK'
            ]);
        } catch (\Throwable $e) {

            /* ===== ERROR END ===== */
            $db -> table(BaseModel::TBL_CRONJOBS)
                    -> where('job_key', $jobName)
                    -> update([
                        'is_running'  => 0,
                        'last_status' => 'ERROR'
            ]);

            throw $e;
        } finally {
            if (file_exists($lock)) {
                unlink($lock);
            }
            CLI::write("CRON END " . date('H:i:s'), 'green');
        }
    }

    protected function runLoop(): void {
        $endTime   = time() + $this -> maxRuntime;
        $iteration = 1;

        while (time() < $endTime) {
            CLI::write("ITERATION {$iteration} @ " . date('H:i:s'), 'cyan');

            $this -> handleIteration($iteration);

            $iteration++;

            // Ако няма време за още една пауза – прекратяваме цикъла
            if (time() + $this -> delay >= $endTime) {
                break;
            }

            sleep($this -> delay);
        }
    }

    protected function prepareEnvironment(): void {
        ini_set('memory_limit', '1024M');
        set_time_limit(0);
        ignore_user_abort(true);

        ini_set('display_errors', '1');
        //ini_set('log_errors', '1');
        // ini_set('error_log', '/home/rnr75/logs/gensoft/cron-gensoft-error.log');
        error_reporting(E_ALL);

        mb_internal_encoding('UTF-8');
        setlocale(LC_ALL, 'C');

        while (ob_get_level()) {
            ob_end_clean();
        }

        gc_enable();
        gc_collect_cycles();

        ini_set('opcache.enable_cli', '1');
    }

    abstract protected function handleIteration(int $iteration);
}
