
<?php

// Инпортиране на фирми от Gensoft база данни
require_once dirname(__DIR__, str_contains(__DIR__, 'debug') ? 2 : 1) . '/cronJobs/BaseCron.php';

class CRON__import_Firms_from_Gensoft extends BaseCron {

    protected int $maxRuntime = 60; // бр. итерации(колко пъти да се стартира)
    protected int $delay      = 10;
    protected int $staleLock  = 120;

    protected function handleIteration(int $iteration) {
        /*  1. Зареждане на ci4 services и helpers.
          ------------------------------------------------------------ */
        $db       = \Config\Database::connect();
        $fb       = service('firebirdConnection');
        $fbServ   = service('firebirdServices');
        $settings = (object) service('settings') -> get('App.gensoft');
        $firma    = [];

        helper('utils');
        dd(1);
        $host = $settings -> gensoftSrv;

        /* Извличаме само IP адреса (за ping / socket check)
          ------------------------------------------------------------ */
        $ip = h_extractIp($settings -> gensoftSrv);

        /* Проверка дали firebird сървърът е достъпен.
          ------------------------------------------------------------ */
        if (!$fb -> isReachable($ip) || empty($host)) {
            die();
        }

        /* Свързване към firebird базата.
          ------------------------------------------------------------ */
        $dbh = $fb -> connect($host);

        if (!$fbServ -> hasTriggers($dbh)) {
            die('❌ Грешка липсват тригерите');
        }

        $stmt = "
select 
    ID_FIRMA, 
    FIRMA,
    MOL,
    TEL, 
    CITY, 
    ADDR, 
    EMAIL, 
    F_GRUPA,
    BULSTAT,
    IS_ACTIVE,
    DATEADD(DT_CHANGED SECOND TO DATE '1984-08-01') as DT_CHANGED	
from FIRMI 
where 
    TIP = 'K' and ID_FIRMA is not null and BULSTAT <>'' " . " ";

// ako автоматично обновяваме
        if (!isset($_GET['import_gensoftData'])) {
            $stmt .= "and DATEADD(DT_CHANGED SECOND TO DATE '1984-08-01') >= CURRENT_DATE " . " ";
        } else {
            // при ръчно обновяваме
            $db -> query("UPDATE _klient SET isActive = NULL WHERE gensoft_firm_id IS NOT NULL ");
        }

        $stmt .= "order by ID_FIRMA asc";

        $firma = [];

        $sth = ibase_query($dbh, $stmt);
        while ($row = ibase_fetch_object($sth)) {
            if ($row && !empty($row -> ID_FIRMA)) {
                $firma[$row -> ID_FIRMA] = [
                    'ID_FIRMA'  => $row -> ID_FIRMA,
                    'FIRMA'     => h_UTF8N($row -> FIRMA),
                    'MOL'       => h_UTF8N($row -> MOL),
                    'TEL'       => h_UTF8N($row -> TEL),
                    'CITY'      => h_UTF8N($row -> CITY),
                    'ADDR'      => h_UTF8N($row -> ADDR),
                    'EMAIL'     => h_UTF8N($row -> EMAIL),
                    'F_GRUPA'   => empty($row -> F_GRUPA) ? "'други'" : h_UTF8N($row -> F_GRUPA),
                    'BULSTAT'   => h_UTF8N($row -> BULSTAT),
                    'ZENA_NIVO' => "'Цена Кл'",
                    'IS_ACTIVE' => h_UTF8N($row -> IS_ACTIVE),
                        //'DT_CHANGED' => $row -> DT_CHANGED
                ];
            }
        }

        ibase_free_result($sth);
        ibase_close($dbh);

        if (!empty($firma)) {
            foreach ($firma as $val) {
                $keysImp = implode(',', array_keys($val));

                $insertValues[] = "(" . implode(', ', array_map(function ($value) {
                                    return is_null($value) || $value == '' ? 'NULL' : trim($value);
                                }, $val)) . ")";
            }

            $insertColumns = array_map(fn($col) => match ($col) {
                        'ID_FIRMA' => 'gensoft_firm_id',
                        'FIRMA' => 'klient_name',
                        'MOL' => 'klient_mol',
                        'TEL' => 'klient_tel',
                        'CITY' => 'klient_grad',
                        'ADDR' => 'klient_adres',
                        'EMAIL' => 'email',
                        'F_GRUPA' => 'group_kl',
                        'BULSTAT' => 'bulstat',
                        'ZENA_NIVO' => 'zenaNivo',
                        'IS_ACTIVE' => 'isActive',
                        default => $col,
                    }, explode(',', $keysImp));

            $insertColumns = implode(', ', $insertColumns);
            $insertValues  = implode(', ', $insertValues);

            $sql = "INSERT INTO _klient($insertColumns) VALUES  $insertValues ON DUPLICATE KEY UPDATE 
                    gensoft_firm_id = VALUES(gensoft_firm_id),
					isActive = VALUES(isActive),
                    klient_name = VALUES(klient_name),
                    klient_mol = VALUES(klient_mol), 
                    klient_tel = VALUES(klient_tel), 
                    klient_grad = VALUES(klient_grad), 
                    klient_adres = VALUES(klient_adres), 
                    email = VALUES(email),
                    group_kl = VALUES(group_kl), 
                    bulstat = VALUES(bulstat)";

            try {
                $db -> query($sql);
            } catch (\Throwable $e) {
                echo json_encode(['error' => $db -> error()], JSON_UNESCAPED_UNICODE);
                return false;
            }

            echo json_encode('Импортването на клиенти е успешно', JSON_UNESCAPED_UNICODE);
        }
    }

}

$cron = new CRON__import_Firms_from_Gensoft();
$cron -> run($cron::class);
