<?php

require_once dirname(__DIR__, str_contains(__DIR__, 'debug') ? 2 : 1) . '/cronJobs/BaseCron.php';

use \App\Models\BaseModel;

class CRON__relatedProducts_generate extends BaseCron {

    protected int $maxRuntime = 1; // бр. итерации(колко пъти да се стартира)
    protected int $delay      = 1;
    protected int $staleLock  = 5;

    public function __construct() {
        parent::__construct();

        date_default_timezone_set('Europe/Sofia');
        $settings = service('settings');
        $general  = $settings -> get('App.general') ?? [];
        $cfg      = $general['related_generator'] ?? [];

        // override на параметрите от BaseCron
        $this -> maxRuntime = (int) ($cfg['crawl_time'] ?? $this -> maxRuntime);
        $this -> delay      = (int) ($cfg['min_timer'] ?? $this -> delay);
        $this -> staleLock  = $this -> maxRuntime;

        $this -> cfg = $cfg;
        $this -> db  = db_connect();
    }

    protected function handleIteration(int $iteration) {
        $cfg = $this -> cfg;
        $db  = $this -> db;

        $nL        = (php_sapi_name() === 'cli' ? PHP_EOL : '<br>');
        $today     = date('Y-m-d H:i:s');
        $batchSize = 50;
        $offset    = 0;

        //  DATE RANGE (TODAY)
        // ===============================
        echo $nL . 'CRON Related Generator (TODAY)' . $nL;
        echo "Batch: {$batchSize}" . $nL;
        echo "delay: {$this -> delay}s | maxRuntime: {$this -> maxRuntime}s" . $nL;

        //  BATCH LOOP
        // ===============================
        $offset = ($iteration - 1) * $batchSize;

        // get today products (no active filter!)
        $products = $db -> table(BaseModel::TBL_PRODUCT)
                        -> select('product_id')
                        -> where("STR_TO_DATE(date_product_create, '%d-%m-%Y %H:%i') BETWEEN '$today 00:00' AND '$today 23:59'")

                        // -> where('date_product_create <=', $todayEnd)
                        -> orderBy('product_id', 'ASC')
                        -> limit($batchSize, $offset)
                        //-> getCompiledSelect();
                        -> get() -> getResultArray();

        if (empty($products)) {
            echo '✅ No more products for today' . $nL;
            return;
        }

        echo "▶ Processing batch (offset {$offset})" . $nL;

        foreach ($products as $p) {
            $this -> generateRelatedForProduct((int) $p['product_id'], $db, $cfg);
            echo "✔ Product {$p['product_id']}" . $nL;
        }

        echo $nL . 'DONE.' . $nL;
    }

    //  CORE LOGIC (SAME AS YOUR CONTROLLER, CLEAN VERSION)
    // ======================================================
    public function generateRelatedForProduct(int $productId, $db, array $cfg) {
        $field     = $cfg['rel_field'] ?? 'product_name';
        $substrLen = (int) ($cfg['rel_substr_len'] ?? 10);
        $likeType  = $cfg['rel_like_type'] ?? 'both';
        $limit     = (int) ($cfg['rel_limit'] ?? 10);

        $sameCategory    = !empty($cfg['rel_same_category']);
        $sameSubcategory = !empty($cfg['rel_same_subcategory']);
        // ❌ NO active filter on purpose

        $base = $db -> table(BaseModel::TBL_PRODUCT)
                        -> where('product_id', $productId)
                        -> get() -> getRowArray();

        if (!$base || empty($base[$field])) {
            return;
        }

        $needle = mb_substr($base[$field], 0, $substrLen);
        if (!$needle)
            return;

        $like = match ($likeType) {
            'start' => $needle . '%',
            'end' => '%' . $needle,
            default => '%' . $needle . '%',
        };

        $qb = $db -> table(BaseModel::TBL_PRODUCT)
                -> select('product_id')
                -> like($field, $like)
                -> where('product_id !=', $productId);

        if ($sameCategory && !empty($base['category_id'])) {
            $qb -> where('category_id', $base['category_id']);
        }

        if ($sameSubcategory && !empty($base['subCat_id'])) {
            $qb -> where('subCat_id', $base['subCat_id']);
        }

        $rows = $qb -> limit($limit) -> get() -> getResultArray();

        if (!$rows) {
            return;
        }

        $ids = [];
        foreach ($rows as $r) {
            $ids[] = (string) $r['product_id'];
        }

        $db -> table(BaseModel::TBL_PRODUCT)
                -> where('product_id', $productId)
                -> set('related_products', json_encode($ids))
                -> update();

        return true;
    }

}

$cron = new CRON__relatedProducts_generate();
$cron -> run($cron::class);
