
<?php

require_once dirname(__DIR__, str_contains(__DIR__, 'debug') ? 2 : 1) . '/cronJobs/BaseCron.php';

class Debug_CRON__import_Products_from_Gensoft extends BaseCron {

    protected int $maxRuntime = 1; // бр. итерации(колко пъти да се стартира)
    protected int $delay      = 1;
    protected int $staleLock  = 5;

    protected function handleIteration(int $iteration) {
        /*  1. Зареждане на ci4 services и helpers.
          ------------------------------------------------------------ */
        $db       = \Config\Database::connect();
        $fb       = service('firebirdConnection');
        $fbServ   = service('firebirdServices');
        $settings = (object) service('settings') -> get('App.gensoft');

        helper('utils');

        $baseSklad     = [];
        $bravas_sklad  = [];
        $insertValues  = [];
        $insertColumns = null;

        $fbColumns = [
            'ITEM_ID',
            'BARCODE',
            'SKLAD',
            'STOKA',
            'GRUPA',
            'CODE',
            'IS_SER_NO',
            'CENA_KUP',
            'TOTAL_KOLICH',
            'VALUTA_KUP',
            'RAZFAS1',
            'KOLICH_LOCKED',
            'STOKA_CHANGED',
            'DATA_CHANGED'
        ];

        /** SKLADS
          ------------------------------------------------------------ */
        $primarySklad = array_filter([
            $_ENV['app.baseSklad'] ?? null,
            $_ENV['app.sklad2'] ?? null,
            $_ENV['app.sklad3'] ?? null
                ]
        );

        $secondSklad = array_filter([
            $_ENV['app.sklad4'] ?? null
                ]
        );

        /**  UNIT MAP
          ------------------------------------------------------------ */
        $q = $db -> query('SELECT sp_mqrka_id, canonical_unit FROM _sp_mqrka') -> getResultArray();

        $unitMap  = array_column($q, 'sp_mqrka_id', 'canonical_unit');
        $genToday = h_dateToGenDT2(new DateTime('now', new DateTimeZone('UTC')));

//$start_time = microtime(true);
        for ($i = 0; $i <= 1; $i++) {

            $currentHost = ($i === 0) ? ($settings -> gensoftSrv ?? '') : ($settings -> gensoftSrv2 ?? '');

            $ip = h_extractIp($currentHost);

            $currentSklad = ($i === 0) ? $primarySklad : $secondSklad;

            if (!$fb -> isReachable($ip) || empty($currentHost)) {
                die('Сървара е недостъпен');
            }

            $dbh = $fb -> connect($currentHost);

            if (!$fbServ -> hasTriggers($dbh)) {
                die('❌ Грешка липсват тригерите');
            }

            $searchSkladArr = [];
            foreach ($currentSklad as $sklad) {
                $searchSkladArr[] = h_CP1251("'$sklad'");
            }

            $searchSkladSql = implode(',', $searchSkladArr);

//WHERE CAST( STOKA_CHANGED AS DATE) = CURRENT_DATE and IS_TRIGGER_UPDATE =1 AND

            $stmt = "
                SELECT 
                    DEF.ITEM_ID, 
                    SP.CENA as PROMOPERCENT,
                    CAST(T.CENA_PROD_DR1 * 1000 AS INTEGER) / 1000.000 AS KKC,
                    MAX(T.SKLAD) AS SKLAD,
                    DEF.STOKA, 
                    DEF.GRUPA,  
                    TRIM(COALESCE(DEF.CODE, 0)) AS CODE, 
                    TRIM(COALESCE(DEF.BARCODE, 0)) AS BARCODE, 
                    DEF.IS_SER_NO,
                    CASE 
                        WHEN T_LATEST.CENA_KUP <> 0 THEN T_LATEST.CENA_KUP ELSE DEF.CENA_KUP
                    END AS CENA_KUP, 
                    SUM(DISTINCT COALESCE(T.KOLICH, 0)) AS TOTAL_KOLICH, 
                    DEF.VALUTA_KUP,
                    DEF.RAZFAS1, 
                    CASE 
                        WHEN SUM(COALESCE(T.KOLICH_LOCKED, 0)) <> 0 THEN SUM(COALESCE(T.KOLICH_LOCKED, 0))  
                    END AS KOLICH_LOCKED, 
                    DEF.STOKA_CHANGED,
                    T_LATEST.DATA_CHANGED

                FROM STOKI_DEF DEF

                LEFT JOIN  
                     STOKI T ON (DEF.STOKA = T.STOKA AND DEF.GRUPA = T.GRUPA AND T.SKLAD IN ($searchSkladSql))
                         
                -- промо цени с префикс 'promo_'
                LEFT JOIN SPEC_CENI SP ON TRIM(SP.RELATOR) STARTING WITH 'promo_'
                   AND SP.GRUPA = DEF.GRUPA
                   AND (
                        SP.STOKA = DEF.STOKA           -- стоково промо
                        OR SP.STOKA IS  NULL            -- групово промо
                        OR SP.STOKA = ''
                        OR SP.STOKA = 'NULL'
                   )
                   AND SP.dt_changed >= $genToday
         
                -- последната дата на промяна на продукт за дост. цена
                LEFT JOIN (
                    SELECT   STOKA, GRUPA, MAX(DATA_CHANGED) AS LATEST_DATA_CHANGED
                    FROM     STOKI
                    WHERE    SKLAD IN ($searchSkladSql)
                    GROUP BY STOKA, GRUPA
                ) LATEST ON T.STOKA = LATEST.STOKA AND T.GRUPA = LATEST.GRUPA

                LEFT JOIN 
                    STOKI T_LATEST ON T.STOKA = T_LATEST.STOKA AND T.GRUPA = T_LATEST.GRUPA AND T_LATEST.DATA_CHANGED > LATEST.LATEST_DATA_CHANGED

WHERE ";
            // за втория склад взимаме само продукти които имат промяна в количеството за година назад от текущата дата
            if ($i == 0) {
                $stmt .= ' T.KOLICH_CHANGED >= CURRENT_DATE - 365 AND ';
            }

            // при ръчно обновяване се пропуска проверка по текуща дата
            if (!isset($_GET['import_gensoftData'])) {
                $stmt .= ' (CAST(DEF.STOKA_CHANGED AS DATE) = CURRENT_DATE
                            OR SP.STOKA IS NOT NULL ) AND ';
            }

            $stmt .= " (T.SKLAD IN ($searchSkladSql) OR T.SKLAD IS NULL )
                        AND DEF.ITEM_ID IS NOT NULL AND DEF.ITEM_ID <> 0

                    GROUP BY 
                        DEF.ITEM_ID, 
                        SP.CENA,
                        T.CENA_PROD_DR1,
                        DEF.STOKA, 
                        DEF.GRUPA,
                        TRIM(COALESCE(DEF.CODE, 0)),
                        TRIM(COALESCE(DEF.BARCODE, 0)),
                        DEF.IS_SER_NO,
                         CASE
                            WHEN T_LATEST.CENA_KUP <> 0 THEN T_LATEST.CENA_KUP ELSE DEF.CENA_KUP
                        END,  
                        DEF.VALUTA_KUP, 
                        DEF.RAZFAS1, 
                        DEF.STOKA_CHANGED,
                        T_LATEST.DATA_CHANGED

                    ORDER BY  DEF.ITEM_ID asc;";

            $sth = ibase_query($dbh, $stmt);

            while ($row = ibase_fetch_object($sth)) {

                $value = [];
                foreach ($fbColumns as $col) {
                    $value[$col] = h_UTF8N($row -> $col);
                    if ($value[$col] === 'NULL' || $value[$col] === '') {
                        $value[$col] = null;
                    }
                }

                if (!empty($value['BARCODE'])) {
                    $value['BARCODE'] = "'" . $value['BARCODE'] . "'";
                }

                if (!empty($value['CODE'])) {
                    $value['CODE'] = "'" . $value['CODE'] . "'";
                }

                $value['DATA_JSON'] = NULL;

                $value['DATA_JSON']['sklad'] = ($value['SKLAD'] !== 'NULL') ? h_replace($value['SKLAD']) : mb_strtoupper($_ENV['app.baseSklad']);

                if (!empty($value['STOKA_CHANGED'])) {
                    $date = substr(h_replace($value['STOKA_CHANGED']), 0, 10);

                    $value['DATA_JSON']['dateStokaChanged'] = $date;
                }

                if (is_numeric($value['KOLICH_LOCKED'])) {
                    $value['DATA_JSON']['kol_lock'] = (float) $value['KOLICH_LOCKED'];
                }
                if ($value['GRUPA'] !== 'NULL') {
                    $value['DATA_JSON']['grupa'] = h_replace($value['GRUPA']);
                }
                if ($value['IS_SER_NO'] !== 'NULL') {
                    $value['DATA_JSON']['is_serNo'] = h_replace($value['IS_SER_NO']);
                }

                if ($value['SKLAD'] == 'NULL') {
                    $value['DATA_JSON']['noData'] = 1;
                }

                if (!empty($row -> PROMOPERCENT)) {
                    $value['DATA_JSON']['promoPercent'] = h_replace($row -> PROMOPERCENT);
                }

                if (!empty($row -> KKC)) {
                    $value['DATA_JSON']['KKC'] = $row -> KKC;
                }

                $rawUnit          = h_UTF8($row -> RAZFAS1);
                $norm             = $rawUnit ? h_normalizeUnit($rawUnit) : null;
                $value['RAZFAS1'] = $unitMap[$norm] ?? null;

                if ($i == 0) {
                    $baseSklad[$row -> ITEM_ID] = $value;
                } elseif ($i == 1) {
                    $bravas_sklad[$row -> ITEM_ID] = $value;
                }
            }

            ibase_free_result($sth);
            ibase_close($dbh);
            dd($baseSklad);
        }

        /**  MERGE BASE + SECOND BY BARCODE Групиране на продукти от складовете
          --------------------------------------------------------------------- */
        $mergedProducts = [];

        foreach ($baseSklad as $item) {
            if (!empty($item['BARCODE'])) {
                $mergedProducts[$item['BARCODE']] = $item;
            }
        }

        foreach ($bravas_sklad as $item) {
            $barcode = $item['BARCODE'];

            if (empty($barcode))
                continue;

            if (isset($mergedProducts[$barcode])) {
                $ref                 = &$mergedProducts[$barcode]; // препратка към елемента
                // 🟢 Съвпадение → събирай количества и копирай цена, група, коллок и т.н.
                $ref['TOTAL_KOLICH'] = (int) ($ref['TOTAL_KOLICH'] ?? 0) + (int) ($item['TOTAL_KOLICH'] ?? 0);

                // Количества по заключени
                $lock1 = is_numeric($ref['KOLICH_LOCKED']) ? (float) $ref['KOLICH_LOCKED'] : 0;
                $lock2 = is_numeric($item['KOLICH_LOCKED']) ? (float) $item['KOLICH_LOCKED'] : 0;

                if (($lock1 + $lock2) > 0) {
                    $ref['DATA_JSON']['kol_lock'] = $lock1 + $lock2;
                }

                $ref['DATA_JSON']['isBravas'] = 1;

                if (!empty($item['GRUPA'])) {
                    $ref['DATA_JSON']['grupa'] = h_replace($item['GRUPA']);
                }

                unset($ref);
            } else {
                // 🔴 Няма съвпадение → добави новия елемент
                $item['DATA_JSON']['isBravas'] = 1;
                $mergedProducts[$barcode]      = $item;
            }
        }

        if (empty($mergedProducts)) {
            echo "✅ Няма продукти за обновяване";
            return true;
        }

        /**  INSERT
          ------------------------------------------------------------ */
        foreach ($mergedProducts as $item) {
            // Добави задължителни полета
            $item['is_manual_impGensoft'] = isset($_GET['import_gensoftData']) ? 1 : null;
            $item['gensoft_productName']  = $item['STOKA'] ?? null;
            $item['Active']               = 1;

            // JSON
            $item['gensoft_json'] = empty($item['DATA_JSON']) ?
                    null :
                    "'" . json_encode($item['DATA_JSON'], JSON_UNESCAPED_UNICODE) . "'";

            // Премахване на ненужните
            foreach (['STOKA_CHANGED', 'IS_SER_NO', 'DATA_JSON', 'DATA_CHANGED',
        'SKLAD', 'GRUPA', 'KOLICH_LOCKED', 'VALUTA_KUP', 'STOKA', 'ITEM_ID'] as $key) {
                unset($item[$key]);
            }

            // Вземи колоните само веднъж
            if ($insertColumns == null) {
                $insertColumns = array_keys($item);
            }

            // Подготви VALUES
            $insertValues[] = "(" . implode(', ', array_map(function ($val) {
                                return is_null($val) || $val == '' ? 'NULL' : trim($val);
                            }, $item)) . ")";
        }


        $insertColumns = array_map(fn($c) => match ($c) {
                    'BARCODE' => 'gensoft_item_id',
                    'RAZFAS1' => 'sp_mqrka_id',
                    'CODE' => 'kod',
                    'CENA_KUP' => 'price_dostavna',
                    'TOTAL_KOLICH' => 'nalichnost',
                    default => $c,
                }, $insertColumns);

        echo '<pre>';
        d($mergedProducts);
        d($insertValues);
        dd($insertColumns);
        $total         = count($insertValues);
        $insertColumns = implode(', ', $insertColumns);
        $insertValues  = implode(', ', $insertValues);

        /*
          if (isset($_GET['import_gensoftData'])) {
          $db -> query('UPDATE _product SET is_manual_impGensoft =NULL');
          }

          $db -> query('UPDATE _product SET Active = NULL');
          $sql = "INSERT INTO _product($insertColumns) VALUES  $insertValues ON DUPLICATE KEY UPDATE
          gensoft_item_id = VALUES(gensoft_item_id),
          gensoft_productName = VALUES(gensoft_productName),
          kod = VALUES(kod),
          sp_mqrka_id = VALUES(sp_mqrka_id),
          price_dostavna = VALUES(price_dostavna),
          gensoft_json = IF(_product.is_manual_impGensoft = 1, _product.gensoft_json, VALUES(gensoft_json)),
          Active = VALUES(Active),
          nalichnost = IF(_product.is_manual_impGensoft = 1, _product.nalichnost, VALUES(nalichnost)),
          is_manual_impGensoft =  IF(_product.is_manual_impGensoft = 1, _product.is_manual_impGensoft, VALUES(is_manual_impGensoft))
          ";

          //product_name = IF((_product.product_name is null or _product.product_name =''),VALUES(gensoft_productName),_product.product_name),

          try {
          $db -> query($sql);
          } catch (\Throwable $e) {
          echo json_encode(['error' => $db -> error()], JSON_UNESCAPED_UNICODE);
          return false;
          }

          echo json_encode("✅ Импортът на стоката е успешен: {$total} реда", JSON_UNESCAPED_UNICODE);
          return true; */
    }

}

$cron  = new Debug_CRON__import_Products_from_Gensoft();
$cron -> run(str_replace('Debug_', '', $cron::class), $debug = true);
